/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.base.CaseFormat;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.core.RegistriesDataProvider;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.RegistryPatchGenerator;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRegistriesDatapackGenerator<T>
extends RegistriesDatapackGenerator
implements RegistriesDataProvider {
    private final CompletableFuture<HolderLookup.Provider> fullRegistries;
    private final ResourceKey<? extends Registry<T>> registryKey;

    public AbstractRegistriesDatapackGenerator(ResourceKey<? extends Registry<T>> registryKey, DataProviderContext context) {
        this(registryKey, context.getPackOutput(), context.getRegistries());
    }

    public AbstractRegistriesDatapackGenerator(ResourceKey<? extends Registry<T>> registryKey, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, CompletableFuture.completedFuture(RegistryAccess.EMPTY));
        CompletableFuture patchedRegistries = RegistryPatchGenerator.createLookup(registries, (RegistrySetBuilder)new RegistrySetBuilder().add(registryKey, this::addBootstrap));
        this.registries = patchedRegistries.thenApply(RegistrySetBuilder.PatchedRegistries::patches);
        this.fullRegistries = patchedRegistries.thenApply(RegistrySetBuilder.PatchedRegistries::full);
        this.registryKey = registryKey;
    }

    public abstract void addBootstrap(BootstrapContext<T> var1);

    public String getName() {
        return AbstractRegistriesDatapackGenerator.getNameFromRegistryPath(this.registryKey.location().getPath()) + " Registry";
    }

    static String getNameFromRegistryPath(String registryPath) {
        String registryName = registryPath.replaceAll("\\W", "_");
        registryName = (String)CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).convert((Object)registryName);
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)registryName), (char)' ');
    }

    @Override
    public CompletableFuture<HolderLookup.Provider> getRegistries() {
        return this.fullRegistries;
    }

    protected static void registerEnchantment(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> resourceKey, Enchantment.Builder builder) {
        context.register(resourceKey, (Object)builder.build(resourceKey.location()));
    }

    protected static void registerDamageType(BootstrapContext<DamageType> context, ResourceKey<DamageType> resourceKey) {
        context.register(resourceKey, (Object)new DamageType(resourceKey.location().getPath(), 0.1f));
    }

    protected static void registerDamageType(BootstrapContext<DamageType> context, ResourceKey<DamageType> resourceKey, DamageEffects damageEffects) {
        context.register(resourceKey, (Object)new DamageType(resourceKey.location().getPath(), 0.1f, damageEffects));
    }

    protected static void registerTrimMaterial(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> resourceKey, Item ingredient, int descriptionColor, float itemModelIndex) {
        AbstractRegistriesDatapackGenerator.registerTrimMaterial(context, resourceKey, ingredient, descriptionColor, itemModelIndex, Collections.emptyMap());
    }

    protected static void registerTrimMaterial(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> resourceKey, Item ingredient, int descriptionColor, float itemModelIndex, Map<Holder<ArmorMaterial>, String> overrideArmorMaterials) {
        MutableComponent component = Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)resourceKey.location())).withStyle(Style.EMPTY.withColor(descriptionColor));
        TrimMaterial trimMaterial = TrimMaterial.create((String)resourceKey.location().getPath(), (Item)ingredient, (float)itemModelIndex, (Component)component, overrideArmorMaterials);
        context.register(resourceKey, (Object)trimMaterial);
    }
}

