/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.components;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public final class TooltipRenderHelper {
    private TooltipRenderHelper() {
    }

    public static List<Component> getTooltipLines(ItemStack itemStack) {
        return TooltipRenderHelper.getTooltipLines(itemStack, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    public static List<Component> getTooltipLines(ItemStack itemStack, TooltipFlag tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        Minecraft minecraft = Minecraft.getInstance();
        return itemStack.getTooltipLines(Item.TooltipContext.of((Level)minecraft.level), (Player)minecraft.player, tooltipFlag);
    }

    public static List<ClientTooltipComponent> getTooltip(ItemStack itemStack) {
        return TooltipRenderHelper.getTooltip(itemStack, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    public static List<ClientTooltipComponent> getTooltip(ItemStack itemStack, TooltipFlag tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        List<Component> components = TooltipRenderHelper.getTooltipLines(itemStack, tooltipFlag);
        List<TooltipComponent> imageComponents = itemStack.getTooltipImage().map(List::of).orElse(List.of());
        return TooltipRenderHelper.createClientComponents(components, imageComponents);
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, ItemStack itemStack) {
        Objects.requireNonNull(itemStack, "item stack is null");
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.getTooltip(itemStack));
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, Component component, TooltipComponent imageComponent) {
        Objects.requireNonNull(component, "component is null");
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, List.of(component), imageComponent);
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, List<Component> components, TooltipComponent imageComponent) {
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of(imageComponent));
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, List<Component> components) {
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of());
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, List<Component> components, List<TooltipComponent> imageComponents) {
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.createClientComponents(components, imageComponents));
    }

    public static List<ClientTooltipComponent> createClientComponents(List<Component> components, List<TooltipComponent> imageComponents) {
        return TooltipRenderHelper.createClientComponents(components, imageComponents, 1);
    }

    public static List<ClientTooltipComponent> createClientComponents(List<Component> components, List<TooltipComponent> imageComponents, int insertAt) {
        List clientComponents = components.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).collect(Collectors.toList());
        List<ClientTooltipComponent> clientImageComponents = imageComponents.stream().map(ClientAbstractions.INSTANCE::createImageComponent).toList();
        if (insertAt == -1) {
            clientComponents.addAll(clientImageComponents);
        } else {
            clientComponents.addAll(Math.min(clientComponents.size(), insertAt), clientImageComponents);
        }
        return ImmutableList.copyOf(clientComponents);
    }

    public static void renderTooltipComponents(GuiGraphics guiGraphics, int posX, int posY, List<? extends ClientTooltipComponent> components) {
        int i;
        if (components.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        boolean result = ClientAbstractions.INSTANCE.onRenderTooltip(guiGraphics, minecraft.font, posX, posY, components, DefaultTooltipPositioner.INSTANCE);
        if (result) {
            return;
        }
        int lineWidth = 0;
        int lineHeight = components.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent component : components) {
            int width = component.getWidth(minecraft.font);
            if (width > lineWidth) {
                lineWidth = width;
            }
            lineHeight += component.getHeight();
        }
        guiGraphics.pose().pushPose();
        TooltipRenderHelper.renderTooltipBackground(guiGraphics, posX += 12, posY -= 12, lineWidth, lineHeight);
        guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
        int currentPosY = posY;
        for (i = 0; i < components.size(); ++i) {
            ClientTooltipComponent component = components.get(i);
            component.renderText(minecraft.font, posX, currentPosY, guiGraphics.pose().last().pose(), guiGraphics.bufferSource());
            currentPosY += component.getHeight() + (i == 0 ? 2 : 0);
        }
        currentPosY = posY;
        for (i = 0; i < components.size(); ++i) {
            ClientTooltipComponent component = components.get(i);
            component.renderImage(minecraft.font, posX, currentPosY, guiGraphics);
            currentPosY += component.getHeight() + (i == 0 ? 2 : 0);
        }
        guiGraphics.flush();
        guiGraphics.pose().popPose();
    }

    private static void renderTooltipBackground(GuiGraphics guiGraphics, int posX, int posY, int lineWidth, int lineHeight) {
        guiGraphics.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)posX, (int)posY, (int)lineWidth, (int)lineHeight, (int)400));
    }
}

