/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.prism.item;

import com.anthonyhilyard.prism.Prism;
import com.anthonyhilyard.prism.text.DynamicColor;
import com.anthonyhilyard.prism.text.TextColors;
import com.anthonyhilyard.prism.util.IColor;
import com.anthonyhilyard.prism.util.WebColors;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ItemColors {
    private static boolean logItemColorError = true;

    public static TextColor getColorForItem(ItemStack item, TextColor defaultColor) {
        TextColor result;
        block10: {
            TextColor formattingColor;
            result = null;
            result = item.getDisplayName().getStyle().getColor();
            if (item.getItem() != null && item.getItem().getName(item) != null && item.getItem().getName(item).getStyle() != null && item.getItem().getName(item).getStyle().getColor() != null) {
                result = item.getItem().getName(item).getStyle().getColor();
            }
            if (!item.getHoverName().getStyle().isEmpty() && item.getHoverName().getStyle().getColor() != null) {
                result = item.getHoverName().getStyle().getColor();
            }
            if ((formattingColor = TextColors.findFirstColorCode(item.getHoverName())) != null) {
                result = formattingColor;
            }
            ColorCollector colorCollector = new ColorCollector();
            item.getHoverName().getVisualOrderText().accept((FormattedCharSink)colorCollector);
            if (colorCollector.getColor() != null) {
                result = colorCollector.getColor();
            }
            if (result == null || result.equals((Object)item.getDisplayName().getStyle().getColor())) {
                Minecraft mc = Minecraft.getInstance();
                try {
                    List lines = item.getTooltipLines(Item.TooltipContext.EMPTY, (Player)mc.player, (TooltipFlag)TooltipFlag.Default.ADVANCED);
                    if (!lines.isEmpty() && ((Component)lines.get(0)).getStyle().getColor() != null) {
                        result = ((Component)lines.get(0)).getStyle().getColor();
                    }
                }
                catch (Exception e) {
                    if (!logItemColorError) break block10;
                    logItemColorError = false;
                    Prism.LOGGER.error("Error getting tooltip for item: " + item.toString());
                    Prism.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        if (result == null) {
            result = defaultColor;
        }
        if (result == null) {
            return (TextColor)WebColors.getColor("transparent");
        }
        return new DynamicColor((IColor)result);
    }

    private static class ColorCollector
    implements FormattedCharSink {
        private TextColor color = null;

        private ColorCollector() {
        }

        public boolean accept(int index, Style style, int codePoint) {
            if (style.getColor() != null) {
                this.color = style.getColor();
                return false;
            }
            return true;
        }

        public TextColor getColor() {
            return this.color;
        }
    }
}

