/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import owmii.powah.network.ServerboundPacket;
import owmii.powah.network.packet.InteractWithTankPacket;
import owmii.powah.network.packet.NextEnergyConfigPacket;
import owmii.powah.network.packet.NextRedstoneModePacket;
import owmii.powah.network.packet.SetChannelPacket;
import owmii.powah.network.packet.SwitchGenModePacket;

public final class Network {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("powah");
        registrar.playToServer(NextEnergyConfigPacket.TYPE, NextEnergyConfigPacket.STREAM_CODEC, Network::handleServerbound);
        registrar.playToServer(NextRedstoneModePacket.TYPE, NextRedstoneModePacket.STREAM_CODEC, Network::handleServerbound);
        registrar.playToServer(SetChannelPacket.TYPE, SetChannelPacket.STREAM_CODEC, Network::handleServerbound);
        registrar.playToServer(SwitchGenModePacket.TYPE, SwitchGenModePacket.STREAM_CODEC, Network::handleServerbound);
        registrar.playToServer(InteractWithTankPacket.TYPE, InteractWithTankPacket.STREAM_CODEC, Network::handleServerbound);
    }

    private static void handleServerbound(ServerboundPacket packet, IPayloadContext context) {
        if (!context.flow().isServerbound()) {
            throw new IllegalArgumentException("Trying to handle a serverbound packet on the client: " + String.valueOf(packet));
        }
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            context.enqueueWork(() -> packet.handleOnServer(serverPlayer));
        }
    }

    public static void toServer(ServerboundPacket packet) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection != null) {
            connection.send((CustomPacketPayload)packet);
        }
    }
}

