/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.Nullable;
import owmii.powah.api.energy.endernetwork.IEnderExtender;
import owmii.powah.block.Tier;
import owmii.powah.block.energycell.EnergyCellBlock;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.logistics.energy.Energy;

public class EnergyCellItem
extends EnergyBlockItem<EnergyConfig, EnergyCellBlock>
implements IEnderExtender {
    public EnergyCellItem(EnergyCellBlock block, Item.Properties properties, @Nullable ResourceKey<CreativeModeTab> group) {
        super(block, EnergyCellItem.applyRarity(block, properties), group);
    }

    private static Item.Properties applyRarity(EnergyCellBlock block, Item.Properties properties) {
        if (((Tier)block.getVariant()).equals(Tier.CREATIVE)) {
            return properties.component(DataComponents.RARITY, (Object)Rarity.EPIC);
        }
        return properties;
    }

    public boolean isFoil(ItemStack stack) {
        return this.getVariant().equals(Tier.CREATIVE) || super.isFoil(stack);
    }

    @Override
    public long getExtendedCapacity(ItemStack stack) {
        if (this.getVariant().equals(Tier.CREATIVE)) {
            return 0L;
        }
        return ((EnergyConfig)this.getConfig()).getCapacity(this.getVariant());
    }

    @Override
    public long getExtendedEnergy(ItemStack stack) {
        if (this.getVariant().equals(Tier.CREATIVE)) {
            return 0L;
        }
        return Energy.getStored(stack);
    }
}

