/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import owmii.powah.Powah;
import owmii.powah.components.BoundPlayer;
import owmii.powah.components.PowahComponents;
import owmii.powah.item.Itms;
import owmii.powah.lib.item.ItemBase;

public class BindingCardItem
extends ItemBase {
    private final boolean isMultiDim;

    public BindingCardItem(Item.Properties properties, boolean isMultiDim) {
        super(properties);
        this.isMultiDim = isMultiDim;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (Powah.config().general.dimensional_binding_card && this == Itms.BINDING_CARD.get() && (target.getClass() == EnderMan.class || target.getClass() == Endermite.class)) {
            if (!playerIn.level().isClientSide) {
                ItemStack stack1 = playerIn.getItemInHand(hand);
                ItemStack stack2 = new ItemStack((ItemLike)Itms.BINDING_CARD_DIM.get());
                stack2.copyFrom((DataComponentHolder)stack1, new DataComponentType[]{PowahComponents.BOUND_PLAYER});
                playerIn.setItemInHand(hand, stack2);
                target.playSound(SoundEvents.ENDERMAN_DEATH, 0.5f, 1.0f);
                target.remove(Entity.RemovalReason.KILLED);
            }
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, playerIn, target, hand);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        BoundPlayer boundPlayer = (BoundPlayer)stack.get(PowahComponents.BOUND_PLAYER);
        if (boundPlayer == null) {
            stack.set(PowahComponents.BOUND_PLAYER, (Object)new BoundPlayer(playerIn.getUUID(), playerIn.getDisplayName().getString()));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!playerIn.getUUID().equals(boundPlayer.gameProfileId())) {
            playerIn.displayClientMessage((Component)Component.translatable((String)"chat.powah.no.binding", (Object[])new Object[]{boundPlayer.name()}).withStyle(ChatFormatting.DARK_RED), true);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public Optional<ServerPlayer> getPlayer(ServerLevel level, ItemStack stack) {
        BoundPlayer boundPlayer = (BoundPlayer)stack.get(PowahComponents.BOUND_PLAYER);
        if (boundPlayer == null) {
            return Optional.empty();
        }
        return owmii.powah.util.Player.get(level, boundPlayer.gameProfileId());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        BoundPlayer boundPlayer = (BoundPlayer)stack.get(PowahComponents.BOUND_PLAYER);
        if (boundPlayer == null) {
            tooltip.add((Component)Component.translatable((String)"info.powah.click.to.bind").withStyle(ChatFormatting.DARK_GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"info.lollipop.owner", (Object[])new Object[]{String.valueOf(ChatFormatting.YELLOW) + boundPlayer.name()}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isMultiDim(ItemStack stack) {
        return this.isMultiDim;
    }
}

