/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.rei.energizing;

import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import owmii.powah.block.energizing.EnergizingRecipe;
import owmii.powah.compat.rei.energizing.EnergizingCategory;

public class EnergizingDisplay
implements Display {
    private final RecipeHolder<EnergizingRecipe> holder;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> output;
    private final long energy;

    public EnergizingDisplay(RecipeHolder<EnergizingRecipe> holder) {
        this.holder = holder;
        EnergizingRecipe recipe = (EnergizingRecipe)holder.value();
        this.inputs = EntryIngredients.ofIngredients(recipe.getIngredients());
        this.output = List.of(EntryIngredients.of((ItemStack)recipe.getResultItem()));
        this.energy = recipe.getScaledEnergy();
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.holder.id());
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<EnergizingDisplay> getCategoryIdentifier() {
        return EnergizingCategory.ID;
    }

    public long getEnergy() {
        return this.energy;
    }
}

