/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.portablehole.PortableHole;
import fuzs.portablehole.config.ServerConfig;
import fuzs.portablehole.core.particles.SparkleParticleData;
import fuzs.portablehole.init.ModRegistry;
import fuzs.portablehole.world.level.block.entity.TemporaryHoleBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TemporaryHoleBlock
extends BaseEntityBlock
implements TickingEntityBlock<TemporaryHoleBlockEntity>,
LiquidBlockContainer {
    public static final MapCodec<TemporaryHoleBlock> CODEC = TemporaryHoleBlock.simpleCodec(TemporaryHoleBlock::new);

    public TemporaryHoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntityType<? extends TemporaryHoleBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.TEMPORARY_HOLE_BLOCK_ENTITY_TYPE.value();
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public VoxelShape getOcclusionShape(BlockState blockState, BlockGetter level, BlockPos blockPos) {
        return Shapes.block();
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.block();
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        TemporaryHoleBlockEntity blockEntity;
        if (!((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).sparkParticles) {
            return;
        }
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof TemporaryHoleBlockEntity && (blockEntity = (TemporaryHoleBlockEntity)blockEntity2).getSourceBlockState() != null) {
            int color = ChatFormatting.BLUE.getColor();
            SparkleParticleData sparkle = SparkleParticleData.noClip(1.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 20);
            VoxelShape occlusionShape = blockEntity.getSourceBlockState().getShape((BlockGetter)level, pos);
            occlusionShape.forAllEdges((x0, y0, z0, x1, y1, z1) -> {
                Vec3 from = new Vec3(x0, y0, z0);
                Vec3 to = new Vec3(x1, y1, z1);
                if (Math.pow(random.nextDouble(), 2.0) < from.distanceToSqr(to)) {
                    Vec3 vec3 = from.lerp(to, random.nextDouble());
                    level.addParticle((ParticleOptions)sparkle, (double)pos.getX() + vec3.x(), (double)pos.getY() + vec3.y(), (double)pos.getZ() + vec3.z(), 0.0, 0.0, 0.0);
                }
            });
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }
}

