/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.server;

import java.io.IOException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import team.creative.creativecore.common.config.premade.MobEffectConfig;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.CombatTrackerClone;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.api.event.PlayerBleedOutEvent;
import team.creative.playerrevive.api.event.PlayerRevivedEvent;
import team.creative.playerrevive.cap.Bleeding;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.packet.ReviveUpdatePacket;

public class PlayerReviveServer {
    public static boolean isBleeding(Player player) {
        return PlayerReviveServer.getBleeding(player).isBleeding();
    }

    public static int timeLeft(Player player) {
        return PlayerReviveServer.getBleeding(player).timeLeft();
    }

    public static int downedTime(Player player) {
        return PlayerReviveServer.getBleeding(player).downedTime();
    }

    public static IBleeding getBleeding(Player player) {
        if (player.hasData(PlayerRevive.BLEEDING)) {
            return (IBleeding)player.getData(PlayerRevive.BLEEDING);
        }
        Bleeding bleeding = new Bleeding();
        player.setData(PlayerRevive.BLEEDING, (Object)bleeding);
        return bleeding;
    }

    public static void sendUpdatePacket(Player player) {
        ReviveUpdatePacket packet = new ReviveUpdatePacket(player);
        PlayerRevive.NETWORK.sendToClientTracking((CreativePacket)packet, (Entity)player);
        PlayerRevive.NETWORK.sendToClient((CreativePacket)packet, (ServerPlayer)player);
    }

    public static void startBleeding(Player player, DamageSource source) {
        PlayerReviveServer.getBleeding(player).knockOut(player, source);
        player.getPersistentData().putBoolean("playerrevive:bleeding", true);
        PlayerReviveServer.sendUpdatePacket(player);
    }

    private static void resetPlayer(Player player, IBleeding revive) {
        for (Player helper : revive.revivingPlayers()) {
            PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayer)helper);
        }
        revive.revivingPlayers().clear();
        player.getPersistentData().remove("playerrevive:bleeding");
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static void revive(Player player) {
        IBleeding revive = PlayerReviveServer.getBleeding(player);
        revive.revive();
        for (MobEffectConfig effect : PlayerRevive.CONFIG.revive.revivedEffects) {
            player.addEffect(effect.create());
        }
        PlayerReviveServer.resetPlayer(player, revive);
        player.setHealth((float)PlayerRevive.CONFIG.revive.healthAfter);
        PlayerRevive.CONFIG.sounds.revived.play((Entity)player, SoundSource.PLAYERS);
        NeoForge.EVENT_BUS.post((Event)new PlayerRevivedEvent(player, revive));
        PlayerReviveServer.sendUpdatePacket(player);
        player.setForcedPose(null);
    }

    public static void kill(Player player) {
        IBleeding revive = PlayerReviveServer.getBleeding(player);
        NeoForge.EVENT_BUS.post((Event)new PlayerBleedOutEvent(player, revive));
        DamageSource source = revive.getSource(player.level().registryAccess());
        CombatTrackerClone trackerClone = revive.getTrackerClone();
        if (trackerClone != null) {
            trackerClone.overwriteTracker(player.getCombatTracker());
        }
        player.setHealth(0.0f);
        revive.forceBledOut();
        player.die(source);
        PlayerReviveServer.resetPlayer(player, revive);
        revive.revive();
        player.setForcedPose(null);
        PlayerRevive.CONFIG.sounds.death.play((Entity)player, SoundSource.PLAYERS);
        if (PlayerRevive.CONFIG.banPlayerAfterDeath) {
            try {
                player.getServer().getPlayerList().getBans().add((StoredUserEntry)new UserBanListEntry(player.getGameProfile()));
                player.getServer().getPlayerList().getBans().save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static void removePlayerAsHelper(Player player) {
        for (ServerPlayer member : player.getServer().getPlayerList().getPlayers()) {
            IBleeding revive = PlayerReviveServer.getBleeding((Player)member);
            revive.revivingPlayers().remove(player);
        }
    }
}

