/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.systems.mixes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;

public record JsonMix<T>(Type type, PotionBrewing.Mix<T> mix) implements CodecProvider<JsonMix<?>>
{
    public static Codec<JsonMix<?>> CODEC = PlaceboCodecs.enumCodec(Type.class).dispatch("mix_type", JsonMix::type, Type::codec);

    public JsonMix(Holder<T> pFrom, Ingredient pIngredient, Holder<T> pTo, Type mixType) {
        this(mixType, new PotionBrewing.Mix(pFrom, pIngredient, pTo));
    }

    @Override
    public Codec<? extends JsonMix<?>> getCodec() {
        return CODEC;
    }

    public static enum Type {
        CONTAINER(BuiltInRegistries.ITEM.holderByNameCodec()),
        POTION(BuiltInRegistries.POTION.holderByNameCodec());

        private final MapCodec<JsonMix<?>> codec;

        private <T> Type(Codec<Holder<T>> elementCodec) {
            this.codec = Type.forType(this, elementCodec);
        }

        public MapCodec<JsonMix<?>> codec() {
            return this.codec;
        }

        private static <T> MapCodec<JsonMix<T>> forType(Type type, Codec<Holder<T>> elementCodec) {
            return RecordCodecBuilder.mapCodec(inst -> inst.group((App)elementCodec.fieldOf("from").forGetter(m -> m.mix.from()), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(m -> m.mix.ingredient()), (App)elementCodec.fieldOf("to").forGetter(m -> m.mix.to())).apply((Applicative)inst, (from, ingredient, to) -> new JsonMix(from, (Ingredient)ingredient, to, type)));
        }
    }
}

