/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.payloads;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ButtonClickPayload(int button) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ButtonClickPayload> TYPE = new CustomPacketPayload.Type(Placebo.loc("button_click"));
    public static final StreamCodec<FriendlyByteBuf, ButtonClickPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ButtonClickPayload::button, ButtonClickPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Provider
    implements PayloadProvider<ButtonClickPayload> {
        @Override
        public CustomPacketPayload.Type<ButtonClickPayload> getType() {
            return TYPE;
        }

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, ButtonClickPayload> getCodec() {
            return CODEC;
        }

        @Override
        public void handle(ButtonClickPayload msg, IPayloadContext ctx) {
            if (ctx.player().containerMenu instanceof IButtonContainer) {
                ((IButtonContainer)ctx.player().containerMenu).onButtonClick(msg.button);
            }
        }

        @Override
        public List<ConnectionProtocol> getSupportedProtocols() {
            return List.of(ConnectionProtocol.PLAY);
        }

        @Override
        public Optional<PacketFlow> getFlow() {
            return Optional.of(PacketFlow.SERVERBOUND);
        }

        @Override
        public String getVersion() {
            return "1";
        }
    }

    public static interface IButtonContainer {
        public void onButtonClick(int var1);
    }
}

