/*
 * Decompiled with CFR 0.152.
 */
package fuzs.permanentsponges.world.level.block;

import fuzs.permanentsponges.util.LiquidAbsorptionHelper;
import fuzs.permanentsponges.world.level.block.SpongeMaterial;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class PermanentSpongeBlock
extends Block {
    private final SpongeMaterial spongeMaterial;

    public PermanentSpongeBlock(BlockBehaviour.Properties properties, SpongeMaterial spongeMaterial) {
        super(properties);
        this.spongeMaterial = spongeMaterial;
    }

    public void onPlace(BlockState newState, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!oldState.is(newState.getBlock())) {
                serverLevel.getServer().tell((Runnable)new TickTask(serverLevel.getServer().getTickCount(), () -> PermanentSpongeBlock.removeAllLiquid(this.spongeMaterial, serverLevel, pos, false)));
            }
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        PermanentSpongeBlock.removeAllLiquid(this.spongeMaterial, level, pos, false);
    }

    public static boolean removeAllLiquid(SpongeMaterial spongeMaterial, ServerLevel level, BlockPos pos, boolean fromStick) {
        int spongeRadius = fromStick ? spongeMaterial.getStickDistance() : spongeMaterial.getBlockDistance();
        boolean destroySource = !fromStick && spongeMaterial.shouldDestroyTouchingHot();
        return LiquidAbsorptionHelper.removeAllLiquid(level, pos, spongeRadius, destroySource);
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(oldState, level, pos, newState, movedByPiston);
        if (!oldState.is(newState.getBlock())) {
            BlockPos blockPos;
            int spongeRadius = this.spongeMaterial.getBlockDistance() + 1;
            List<BlockPos> positions = LiquidAbsorptionHelper.getSpongeRadius(spongeRadius);
            int i = positions.size() - 1;
            int j = 0;
            while (i >= 0 && (Math.abs((blockPos = positions.get(i)).getX()) == spongeRadius || Math.abs(blockPos.getY()) == spongeRadius || Math.abs(blockPos.getZ()) == spongeRadius)) {
                blockPos = blockPos.offset((Vec3i)pos);
                level.scheduleTick(blockPos, level.getFluidState(blockPos).getType(), 1);
                --i;
                ++j;
            }
        }
    }
}

