/*
 * Decompiled with CFR 0.152.
 */
package fuzs.paperdoll.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.paperdoll.client.handler.PaperDollHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PaperDollRenderer {
    public static void renderEntityInInventoryUpdateRotations(GuiGraphics guiGraphics, int posX, int posY, int scale, LivingEntity entity, float partialTicks) {
        PlayerRotations playerRotations = new PlayerRotations(entity);
        PaperDollHandler.applyEntityRotations(entity);
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(0.2617994f);
        pose.mul((Quaternionfc)cameraOrientation);
        PaperDollRenderer.renderEntityInInventory(guiGraphics, posX, posY, scale, new Vector3f(), pose, cameraOrientation, entity, partialTicks);
        playerRotations.apply(entity);
    }

    public static void renderEntityInInventory(GuiGraphics guiGraphics, float x, float y, int scale, Vector3f translate, Quaternionf pose, @Nullable Quaternionf cameraOrientation, LivingEntity entity, float partialTick) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)x, (double)y, 50.0);
        guiGraphics.pose().scale((float)scale, (float)scale, (float)(-scale));
        guiGraphics.pose().translate(translate.x, translate.y, translate.z);
        guiGraphics.pose().mulPose(pose);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (cameraOrientation != null) {
            cameraOrientation.conjugate();
            entityRenderDispatcher.overrideCameraOrientation(cameraOrientation);
        }
        entityRenderDispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, partialTick, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0));
        guiGraphics.flush();
        entityRenderDispatcher.setRenderShadow(true);
        guiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }

    private record PlayerRotations(float xRot, float yBodyRot, float yHeadRot, float xRotO, float yBodyRotO, float yHeadRotO) {
        public PlayerRotations(LivingEntity entity) {
            this(entity.getXRot(), entity.yBodyRot, entity.yHeadRot, entity.xRotO, entity.yBodyRotO, entity.yHeadRotO);
        }

        public void apply(LivingEntity entity) {
            entity.setXRot(this.xRot);
            entity.yBodyRot = this.yBodyRot;
            entity.yHeadRot = this.yHeadRot;
            entity.xRotO = this.xRotO;
            entity.yBodyRotO = this.yBodyRotO;
            entity.yHeadRotO = this.yHeadRotO;
        }
    }
}

