/*
 * Decompiled with CFR 0.152.
 */
package fuzs.paperdoll.client.gui;

import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public enum DisplayAction {
    SPRINTING(Entity::canSpawnSprintParticle),
    SWIMMING(Predicate.not(Entity::isVisuallyCrawling).and(LivingEntity::isVisuallySwimming)),
    CRAWLING(Entity::isVisuallyCrawling),
    CROUCHING(Entity::isCrouching),
    FLYING(player -> player.getAbilities().flying),
    GLIDING(LivingEntity::isFallFlying),
    RIDING(Entity::isPassenger),
    SPIN_ATTACKING(LivingEntity::isAutoSpinAttack),
    USING(LivingEntity::isUsingItem);

    final Predicate<Player> action;

    private DisplayAction(Predicate<Player> action) {
        this.action = action;
    }

    public boolean isActive(Player player, int remainingRidingTicks) {
        return (this != CROUCHING || remainingRidingTicks == 0) && this.action.test(player);
    }
}

