/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.packmenu.reload;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.packmenu.PackMenu;
import dev.shadowsoffire.packmenu.buttons.JsonButton;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class ButtonManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().create();
    protected Map<ResourceLocation, JsonButton> buttons = new TreeMap<ResourceLocation, JsonButton>();

    public ButtonManager() {
        super(GSON, "buttons");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager mgr, ProfilerFiller profiler) {
        this.buttons.clear();
        for (Map.Entry<ResourceLocation, JsonElement> obj : objects.entrySet()) {
            try {
                JsonButton btn = (JsonButton)((Object)((Pair)JsonButton.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj.getValue()).getOrThrow()).getFirst());
                this.buttons.put(obj.getKey(), btn);
            }
            catch (Exception e) {
                PackMenu.LOGGER.error("Failed to load button {}.", (Object)obj.getKey());
                e.printStackTrace();
            }
        }
        PackMenu.LOGGER.info("Loaded {} buttons from resources.", (Object)this.buttons.size());
    }

    public Collection<JsonButton> getButtons() {
        return this.buttons.values();
    }
}

