/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.packmenu.panorama;

import dev.shadowsoffire.packmenu.PackMenu;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class VariedCubeMap
extends CubeMap {
    private final ResourceLocation[][] locations = new ResourceLocation[10][6];

    public VariedCubeMap(ResourceLocation texture) {
        super(texture);
        for (int i = 0; i < 6; ++i) {
            this.locations[0][i] = ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)(texture.getPath() + "_" + i + ".png"));
        }
        for (int variation = 1; variation < 10; ++variation) {
            for (int i = 0; i < 6; ++i) {
                this.locations[variation][i] = ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)(texture.getPath() + variation + "_" + i + ".png"));
            }
        }
    }

    public void setVariation(int variation) {
        this.images = this.locations[variation];
    }

    public CompletableFuture<Void> preload(TextureManager texMngr, Executor backgroundExecutor) {
        CompletableFuture[] completablefuture = new CompletableFuture[PackMenu.panoramaVariations * 6];
        for (int i = 0; i < PackMenu.panoramaVariations; ++i) {
            for (int j = 0; j < 6; ++j) {
                completablefuture[i * 6 + j] = texMngr.preload(this.locations[i][j], backgroundExecutor);
            }
        }
        return CompletableFuture.allOf(completablefuture);
    }
}

