/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.packmenu;

import com.google.common.util.concurrent.Runnables;
import com.mojang.math.Axis;
import com.mojang.realmsclient.RealmsMainScreen;
import dev.shadowsoffire.packmenu.PackMenu;
import dev.shadowsoffire.packmenu.buttons.JsonButton;
import dev.shadowsoffire.packmenu.panorama.VariedCubeMap;
import dev.shadowsoffire.packmenu.slideshow.Slideshow;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CommonButtons;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.SafetyScreen;
import net.minecraft.client.gui.screens.options.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.gui.ModListScreen;
import net.neoforged.neoforge.internal.BrandingControl;

public class ExtendedMenuScreen
extends TitleScreen {
    public static final ResourceLocation BACKGROUND = PackMenu.loc("textures/gui/background.png");
    public static VariedCubeMap VARIED_CUBE_MAP = new VariedCubeMap(ResourceLocation.withDefaultNamespace((String)"textures/gui/title/background/panorama"));
    public final PanoramaRenderer panorama = new PanoramaRenderer((CubeMap)VARIED_CUBE_MAP);

    public ExtendedMenuScreen(boolean fade) {
        super(fade);
        Slideshow.reset();
    }

    protected void init() {
        super.init();
        this.renderables.clear();
        this.children().clear();
        if (PackMenu.BUTTON_MANAGER.getButtons().isEmpty()) {
            this.addDefaultButtons();
        } else {
            PackMenu.BUTTON_MANAGER.getButtons().stream().sorted(Comparator.comparing(JsonButton::getYPos).thenComparing(Comparator.comparing(JsonButton::getXPos))).forEach(b -> ((JsonButton)this.addRenderableWidget((GuiEventListener)b)).setup(this));
        }
        int txtWidth = this.font.width((FormattedText)COPYRIGHT_TEXT);
        int leftPos = this.width - txtWidth - 2;
        this.addRenderableWidget((GuiEventListener)new PlainTextButton(leftPos, this.height - 10, txtWidth, 10, COPYRIGHT_TEXT, p_211790_ -> this.minecraft.setScreen((Screen)new WinScreen(false, Runnables.doNothing())), this.font));
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        if (this.fadeInStart == 0L && this.fading) {
            this.fadeInStart = Util.getMillis();
        }
        float fade = 1.0f;
        if (this.fading) {
            float panoramaFade = (float)(Util.getMillis() - this.fadeInStart) / 2000.0f;
            if (panoramaFade > 1.0f) {
                this.fading = false;
                this.panoramaFade = 1.0f;
            } else {
                panoramaFade = Mth.clamp((float)panoramaFade, (float)0.0f, (float)1.0f);
                fade = Mth.clampedMap((float)panoramaFade, (float)0.5f, (float)1.0f, (float)0.0f, (float)1.0f);
                this.panoramaFade = Mth.clampedMap((float)panoramaFade, (float)0.0f, (float)0.5f, (float)0.0f, (float)1.0f);
            }
            this.fadeWidgets(fade);
        }
        if (PackMenu.drawPanorama) {
            this.renderPanorama(gfx, partialTicks);
        } else if (PackMenu.slideshow) {
            Slideshow.render(this, gfx, partialTicks);
        } else {
            gfx.blit(BACKGROUND, 0, 0, this.width, this.height, 0.0f, 0.0f, 16, 128, 16, 128);
        }
        float f1 = this.fading ? Mth.clamp((float)(fade - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        int l = Mth.ceil((float)(f1 * 255.0f)) << 24;
        if ((l & 0xFC000000) != 0) {
            if (PackMenu.drawTitle) {
                this.logoRenderer.renderLogo(gfx, PackMenu.title.getX(this), f1, PackMenu.title.getY(this));
            }
            if (PackMenu.logo != null) {
                PackMenu.logo.draw(this, gfx);
            }
            if (PackMenu.drawForgeInfo) {
                int alpha = (this.fading ? Mth.ceil((float)Mth.clamp((float)fade, (float)0.0f, (float)1.0f)) : 1) << 24;
                int x = PackMenu.forgeWarn.getX(this);
                int y = PackMenu.forgeWarn.getY(this);
                if (x != 0 || y != 0) {
                    gfx.pose().pushPose();
                    gfx.pose().translate((float)x, (float)y, 0.0f);
                    ClientHooks.renderMainMenu((TitleScreen)this, (GuiGraphics)gfx, (Font)this.getFont(), (int)this.width, (int)this.height, (int)alpha);
                    gfx.pose().popPose();
                } else {
                    ClientHooks.renderMainMenu((TitleScreen)this, (GuiGraphics)gfx, (Font)this.getFont(), (int)this.width, (int)this.height, (int)alpha);
                }
            }
            if (this.splash != null && PackMenu.drawSplash && !((Boolean)this.minecraft.options.hideSplashTexts().get()).booleanValue()) {
                gfx.pose().pushPose();
                gfx.pose().translate((float)PackMenu.splash.getX(this), (float)PackMenu.splash.getY(this), 0.0f);
                gfx.pose().mulPose(Axis.ZP.rotationDegrees(PackMenu.splashRotation));
                this.splash.render(gfx, this.width, this.font, PackMenu.splashColor);
                gfx.pose().popPose();
            }
            String s = "Minecraft " + SharedConstants.getCurrentVersion().getName();
            s = s + (String)("release".equalsIgnoreCase(this.minecraft.getVersionType()) ? "" : "/" + this.minecraft.getVersionType());
            if (Minecraft.checkModStatus().shouldReportAsModified()) {
                s = s + I18n.get((String)"menu.modded", (Object[])new Object[0]);
            }
            for (int i = 0; i < this.renderables.size(); ++i) {
                ((Renderable)this.renderables.get(i)).render(gfx, mouseX, mouseY, partialTicks);
            }
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                Font font = this.getFont();
                int n = brdline;
                Objects.requireNonNull(this.getFont());
                gfx.drawString(font, brd, 2, this.height - (10 + n * (9 + 1)), 0xFFFFFF | l);
            });
            BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                Font font = this.getFont();
                int n = this.width - this.getFont().width(brd);
                int n2 = brdline + 1;
                Objects.requireNonNull(this.getFont());
                gfx.drawString(font, brd, n, this.height - (10 + n2 * (9 + 1)), 0xFFFFFF | l);
            });
        }
    }

    public void tick() {
        super.tick();
        for (Renderable b : this.renderables) {
            if (!(b instanceof JsonButton) || !((JsonButton)b).isHoveredOrFocused()) continue;
            ((JsonButton)b).tickScrollCounter();
        }
    }

    private void addDefaultButtons() {
        int buttonHeight = this.height / 4 + 32;
        int buttonWidth = this.width / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.singleplayer"), btn -> this.minecraft.setScreen((Screen)new SelectWorldScreen((Screen)this))).bounds(buttonWidth - 100, buttonHeight, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.multiplayer"), btn -> {
            JoinMultiplayerScreen screen = this.minecraft.options.skipMultiplayerWarning ? new JoinMultiplayerScreen((Screen)this) : new SafetyScreen((Screen)this);
            this.minecraft.setScreen((Screen)screen);
        }).bounds(buttonWidth - 100, buttonHeight + 24, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.online"), btn -> this.minecraft.setScreen((Screen)new RealmsMainScreen((Screen)this))).bounds(buttonWidth + 2, buttonHeight + 48, 98, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"fml.menu.mods"), btn -> this.minecraft.setScreen((Screen)new ModListScreen((Screen)this))).pos(buttonWidth - 100, buttonHeight + 48).size(98, 20).build());
        SpriteIconButton langBtn = (SpriteIconButton)this.addRenderableWidget((GuiEventListener)CommonButtons.language((int)20, btn -> this.minecraft.setScreen((Screen)new LanguageSelectScreen((Screen)this, this.minecraft.options, this.minecraft.getLanguageManager())), (boolean)true));
        langBtn.setPosition(buttonWidth - 124, buttonHeight + 72 + 12);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.options"), btn -> this.minecraft.setScreen((Screen)new OptionsScreen((Screen)this, this.minecraft.options))).bounds(buttonWidth - 100, buttonHeight + 72 + 12, 98, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.quit"), btn -> this.minecraft.stop()).bounds(buttonWidth + 2, buttonHeight + 72 + 12, 98, 20).build());
        SpriteIconButton accessibilityBtn = (SpriteIconButton)this.addRenderableWidget((GuiEventListener)CommonButtons.accessibility((int)20, btn -> this.minecraft.setScreen((Screen)new AccessibilityOptionsScreen((Screen)this, this.minecraft.options)), (boolean)true));
        accessibilityBtn.setPosition(buttonWidth + 104, buttonHeight + 72 + 12);
    }

    public Font getFont() {
        return this.font;
    }
}

