/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators.TYGTreeDecoratorTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class AttachedToFruitLeavesDecorator
extends AttachedToLeavesDecorator {
    public static final MapCodec<AttachedToFruitLeavesDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(decorator -> decorator.exclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(decorator -> decorator.exclusionRadiusY), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("leaves_block").forGetter(decorator -> decorator.leavesBlock), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(decorator -> decorator.blockProvider), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(decorator -> decorator.requiredEmptyBlocks), (App)ExtraCodecs.nonEmptyList((Codec)Direction.CODEC.listOf()).fieldOf("directions").forGetter(decorator -> decorator.directions)).apply((Applicative)instance, AttachedToFruitLeavesDecorator::new));
    private final Block leavesBlock;

    public AttachedToFruitLeavesDecorator(float probability, int exclusionRadiusXZ, int exclusionRadiusY, Block leavesBlock, BlockStateProvider blockProvider, int requiredEmptyBlocks, List<Direction> directions) {
        super(probability, exclusionRadiusXZ, exclusionRadiusY, blockProvider, requiredEmptyBlocks, directions);
        this.leavesBlock = leavesBlock;
    }

    @NotNull
    protected TreeDecoratorType<?> type() {
        return TYGTreeDecoratorTypes.ATTACHED_TO_FRUIT_LEAVES.get();
    }

    public void place(@NotNull TreeDecorator.Context context) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        RandomSource random = context.random();
        ArrayList<BlockPos> leavesPositions = new ArrayList<BlockPos>();
        for (BlockPos pos : context.leaves()) {
            if (!context.level().isStateAtPosition(pos, state -> state.is(this.leavesBlock))) continue;
            leavesPositions.add(pos);
        }
        List shuffledLeaves = Util.shuffledCopy((Object[])leavesPositions.toArray(new BlockPos[0]), (RandomSource)random);
        for (BlockPos pos : shuffledLeaves) {
            Direction direction;
            BlockPos relativePos = pos.relative(direction = (Direction)Util.getRandom((List)this.directions, (RandomSource)random));
            if (positions.contains(relativePos) || !(random.nextFloat() < this.probability) || !this.hasRequiredEmptyBlocks(context, pos, direction)) continue;
            BlockPos minXZ = relativePos.offset(-this.exclusionRadiusXZ, -this.exclusionRadiusY, -this.exclusionRadiusXZ);
            BlockPos maxXZ = relativePos.offset(this.exclusionRadiusXZ, this.exclusionRadiusY, this.exclusionRadiusXZ);
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)minXZ, (BlockPos)maxXZ)) {
                positions.add(blockPos.immutable());
            }
            context.setBlock(relativePos, this.blockProvider.getState(random, relativePos));
        }
    }

    private boolean hasRequiredEmptyBlocks(TreeDecorator.Context context, BlockPos pos, Direction direction) {
        for (int i = 1; i <= this.requiredEmptyBlocks; ++i) {
            BlockPos relativePos = pos.relative(direction, i);
            if (context.isAir(relativePos)) continue;
            return false;
        }
        return true;
    }
}

