/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.placement.VillagePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGTemplatePools;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.BWGStructureProcessorLists;

public class BWGVillageTemplatePools {
    private static final ResourceKey<StructureTemplatePool> SKYRIS_TERMINATOR = BWGVillageTemplatePools.createTerminatorPool("skyris");
    private static final ResourceKey<StructureTemplatePool> SKYRIS_DECOR = BWGVillageTemplatePools.register("skyris/decor", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("skyris/skyris_lamp_1", 10), BWGVillageTemplatePools.featureElement((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<PlacedFeature>)VillagePlacements.PATCH_BERRY_BUSH_VILLAGE, 4), BWGVillageTemplatePools.featureElement((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<PlacedFeature>)VillagePlacements.PILE_HAY_VILLAGE, 4), BWGVillageTemplatePools.emptyPoolElement(6)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> SKYRIS_TOWN_CENTERS = BWGVillageTemplatePools.register("skyris/town_centers", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("skyris/town_centers/skyris_meeting_point_1", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/town_centers/skyris_meeting_point_2", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_TOWN_CENTERS), BWGVillageTemplatePools.singlePoolElement("skyris/town_centers/skyris_meeting_point_3", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_TOWN_CENTERS), BWGVillageTemplatePools.singlePoolElement("skyris/town_centers/skyris_meeting_point_4", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_TOWN_CENTERS)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> SKYRIS_VILLAGERS = BWGVillageTemplatePools.register("skyris/villagers", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("skyris/villagers/baby", 2), BWGVillageTemplatePools.singlePoolElement("skyris/villagers/unemployed", 10)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> SKYRIS_STREETS = BWGVillageTemplatePools.register("skyris/streets", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, SKYRIS_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_corner_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_corner_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_straight_01", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_straight_02", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_straight_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_crossroad_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_crossroad_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_crossroad_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_square_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_square_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/streets/skyris_turn_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
    public static final ResourceKey<StructureTemplatePool> SKYRIS_HOUSES = BWGVillageTemplatePools.register("skyris/houses", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, SKYRIS_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_small_house_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_small_house_2", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_small_house_3", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_TOWN_CENTERS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_small_house_4", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_small_house_5", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_small_house_6", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_medium_house_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_tool_smith_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_butcher_shop_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_fletcher_house_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_FLETCHER_HOUSE), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_forager_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_FORAGER_HOUSE), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_armorer_1"), (Object[])new Pair[]{BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_fisher_1", 2), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_cartographer_house_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_library_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_LIBRARY), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_mason_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_weaponsmith_1", 2), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_temple_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_TEMPLE), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_animal_pen_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_animal_pen_2", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SKYRIS_STREETS), BWGVillageTemplatePools.singlePoolElement("skyris/houses/skyris_large_farm_1", 11, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_DESERT), BWGVillageTemplatePools.emptyPoolElement(7)}), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> FORGOTTEN_TERMINATOR = BWGVillageTemplatePools.createTerminatorPool("forgotten", BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS);
    public static final ResourceKey<StructureTemplatePool> FORGOTTEN_TOWN_CENTERS = BWGVillageTemplatePools.register("forgotten/town_centers", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("forgotten/town_centers/forgotten_meeting_point_1", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/town_centers/forgotten_meeting_point_2", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/town_centers/forgotten_meeting_point_3", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> FORGOTTEN_DECOR = BWGVillageTemplatePools.register("forgotten/decor", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("forgotten/forgotten_lamp_1", 6), BWGVillageTemplatePools.featureElement((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<PlacedFeature>)VillagePlacements.PILE_MELON_VILLAGE, 2), BWGVillageTemplatePools.featureElement((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<PlacedFeature>)VillagePlacements.PILE_HAY_VILLAGE, 1), BWGVillageTemplatePools.emptyPoolElement(6)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> FORGOTTEN_STREETS = BWGVillageTemplatePools.register("forgotten/streets", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, FORGOTTEN_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_corner_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_corner_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_corner_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_straight_01", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_straight_02", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_straight_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_straight_04", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_straight_05", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_straight_06", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_crossroad_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_crossroad_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_crossroad_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), (Object[])new Pair[]{BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_crossroad_04", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_crossroad_05", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_crossroad_06", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.singlePoolElement("forgotten/streets/forgotten_turn_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS)}), StructureTemplatePool.Projection.TERRAIN_MATCHING));
    public static final ResourceKey<StructureTemplatePool> FORGOTTEN_HOUSES = BWGVillageTemplatePools.register("forgotten/houses", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, FORGOTTEN_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("forgotten/houses/forgotten_small_house_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_small_house_2", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_small_house_3", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_small_house_4", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_small_house_5", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_small_house_6", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_small_house_7", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_small_house_8", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_armorer_house_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_butcher_shop_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_butcher_shop_2", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_cartographer_1", 1, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), (Object[])new Pair[]{BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_cartographer_2", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_temple_1", 1, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_temple_2", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_tool_smith_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_animal_pen_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_animal_pen_2", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_animal_pen_3", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_accessory_1", 1, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_accessory_2", 1, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_small_farm_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.legacyPoolElement("forgotten/houses/forgotten_large_farm_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.FORGOTTEN_VILLAGE_BLOCKS), BWGVillageTemplatePools.emptyPoolElement(6)}), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> SALEM_TERMINATOR = BWGVillageTemplatePools.createTerminatorPool("salem", BWGStructureProcessorLists.SALEM_STREETS);
    public static final ResourceKey<StructureTemplatePool> SALEM_TOWN_CENTERS = BWGVillageTemplatePools.register("salem/town_centers", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("salem/town_centers/salem_meeting_point_1", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_TOWN_CENTER), BWGVillageTemplatePools.singlePoolElement("salem/town_centers/salem_meeting_point_2", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_TOWN_CENTER)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> SALEM_DECOR = BWGVillageTemplatePools.register("salem/decor", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("salem/salem_lamp_1", 10), BWGVillageTemplatePools.featureElement((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<PlacedFeature>)VillagePlacements.PILE_HAY_VILLAGE, 2), BWGVillageTemplatePools.emptyPoolElement(6)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> SALEM_STREETS = BWGVillageTemplatePools.register("salem/streets", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, SALEM_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_corner_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_corner_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_straight_01", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_straight_02", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_straight_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_crossroad_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_crossroad_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_crossroad_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_square_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_square_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS), BWGVillageTemplatePools.singlePoolElement("salem/streets/salem_turn_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_STREETS)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
    public static final ResourceKey<StructureTemplatePool> SALEM_VILLAGERS = BWGVillageTemplatePools.register("salem/villagers", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("salem/villagers/baby", 2), BWGVillageTemplatePools.singlePoolElement("salem/villagers/unemployed", 10)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> SALEM_HOUSES = BWGVillageTemplatePools.register("salem/houses", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, SALEM_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("salem/houses/salem_small_house_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.SALEM_HOUSES), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_small_house_2", 3), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_small_house_3", 3), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_medium_house_1", 3), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_medium_house_2", 3), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_medium_house_3", 3), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_medium_house_4", 3), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_shepherd_house_1", 3), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_mason_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_temple", 3), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_weaponsmith_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_toolsmith_1", 2), (Object[])new Pair[]{BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_tannery_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_fisher_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_fletcher_house_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_forager_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_cartographer_house_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_butcher_shop_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_armorsmith_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_animal_pen_1", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_animal_pen_2", 2), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_small_farm_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_TAIGA), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_small_farm_2", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_TAIGA), BWGVillageTemplatePools.legacyPoolElement("salem/houses/salem_large_farm_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_TAIGA), BWGVillageTemplatePools.emptyPoolElement(10)}), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> RED_ROCK_TERMINATOR = BWGVillageTemplatePools.createTerminatorPool("red_rock");
    public static final ResourceKey<StructureTemplatePool> RED_ROCK_TOWN_CENTERS = BWGVillageTemplatePools.register("red_rock/town_centers", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("red_rock/town_centers/red_rock_meeting_point_1", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_MEETING_POINT_1), BWGVillageTemplatePools.singlePoolElement("red_rock/town_centers/red_rock_meeting_point_2", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_CRACKED_BRICKS_50_PERCENT_MOSSY_RED_ROCK_BRICKS), BWGVillageTemplatePools.singlePoolElement("red_rock/town_centers/red_rock_meeting_point_3", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_MEETING_POINT_3)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> RED_ROCK_DECOR = BWGVillageTemplatePools.register("red_rock/decor", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("red_rock/red_rock_lamp_1", 10), BWGVillageTemplatePools.featureElement((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<PlacedFeature>)VillagePlacements.PILE_HAY_VILLAGE, 2), BWGVillageTemplatePools.emptyPoolElement(6)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> RED_ROCK_STREETS = BWGVillageTemplatePools.register("red_rock/streets", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, RED_ROCK_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_corner_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_corner_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_straight_01", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_straight_02", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_straight_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_crossroad_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_crossroad_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_crossroad_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_square_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_square_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS), BWGVillageTemplatePools.singlePoolElement("red_rock/streets/red_rock_turn_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_STREETS)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
    public static final ResourceKey<StructureTemplatePool> RED_ROCK_VILLAGERS = BWGVillageTemplatePools.register("red_rock/villagers", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("red_rock/villagers/baby", 2), BWGVillageTemplatePools.singlePoolElement("red_rock/villagers/unemployed", 10)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> RED_ROCK_HOUSES = BWGVillageTemplatePools.register("red_rock/houses", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, RED_ROCK_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_small_house_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_TO_BRICKS), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_small_house_2", 3), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_small_house_3", 3), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_small_house_4", 3), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_small_house_5", 3), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_medium_house_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_HOUSE), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_medium_house_2", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_HOUSE), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_large_house_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_HOUSE), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_shepherd_house_1", 3), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_mason_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_HOUSE), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_cleric", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.RED_ROCK_HOUSE), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_farm_small_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_DESERT), (Object[])new Pair[]{BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_farm_small_2", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_DESERT), BWGVillageTemplatePools.singlePoolElement("red_rock/houses/red_rock_farm_large_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_DESERT)}), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> PUMPKIN_PATCH_TERMINATOR = BWGVillageTemplatePools.createTerminatorPool("pumpkin_patch", BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS);
    public static final ResourceKey<StructureTemplatePool> PUMPKIN_PATCH_TOWN_CENTERS = BWGVillageTemplatePools.register("pumpkin_patch/town_centers", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/town_centers/pumpkin_patch_meeting_point_1", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_MEETING_POINT_1), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/town_centers/pumpkin_patch_meeting_point_2", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_MEETING_POINT_2), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/town_centers/pumpkin_patch_meeting_point_3", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_HOUSE)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> PUMPKIN_PATCH_DECOR = BWGVillageTemplatePools.register("pumpkin_patch/decor", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/pumpkin_patch_lamp_1", 10), BWGVillageTemplatePools.featureElement((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<PlacedFeature>)VillagePlacements.PILE_PUMPKIN_VILLAGE, 2), BWGVillageTemplatePools.featureElement((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<PlacedFeature>)VillagePlacements.PILE_HAY_VILLAGE, 1), BWGVillageTemplatePools.emptyPoolElement(5)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> PUMPKIN_PATCH_STREETS = BWGVillageTemplatePools.register("pumpkin_patch/streets", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, PUMPKIN_PATCH_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_corner_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_corner_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_straight_01", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_straight_02", 4, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_straight_03", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_crossroad_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_crossroad_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_square_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_square_02", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/streets/pumpkin_patch_turn_01", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_STREETS)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
    public static final ResourceKey<StructureTemplatePool> PUMPKIN_PATCH_HOUSES = BWGVillageTemplatePools.register("pumpkin_patch/houses", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, PUMPKIN_PATCH_TERMINATOR), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_small_house_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_HOUSE), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_small_house_2", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_HOUSE), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_small_house_3", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_HOUSE), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_small_house_4", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_HOUSE), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_medium_house_1", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_HOUSE), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_medium_house_2", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_HOUSE), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_medium_house_3", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PUMPKIN_PATCH_HOUSE), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_small_farm_1", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_TAIGA), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_small_farm_2", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_TAIGA), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_small_farm_3", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_TAIGA), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_small_farm_4", 3, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_TAIGA), BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/houses/pumpkin_patch_small_farm_5", 2, (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.FARM_TAIGA), (Object[])new Pair[]{BWGVillageTemplatePools.emptyPoolElement(10)}), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> PUMPKIN_PATCH_WARDS = BWGVillageTemplatePools.register("pumpkin_patch/wards", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.singlePoolElement("pumpkin_patch/wards/pumpkin_ward")), StructureTemplatePool.Projection.RIGID));

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> emptyPoolElement(int weight) {
        return Pair.of((Object)StructurePoolElement.empty(), (Object)weight);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> featureElement(BootstrapContext<StructureTemplatePool> context, ResourceKey<PlacedFeature> placedFeature, int weight) {
        return Pair.of((Object)StructurePoolElement.feature((Holder)context.lookup(Registries.PLACED_FEATURE).getOrThrow(placedFeature)), (Object)weight);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> legacyPoolElement(String id) {
        return BWGVillageTemplatePools.legacyPoolElement(id, 1);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> legacyPoolElement(String id, int weight) {
        return Pair.of((Object)StructurePoolElement.legacy((String)BiomesWeveGone.id("village/" + id).toString()), (Object)weight);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> legacyPoolElement(String id, BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureProcessorList> processorList) {
        return BWGVillageTemplatePools.legacyPoolElement(id, 1, context, processorList);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> legacyPoolElement(String id, int weight, BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureProcessorList> processorList) {
        return Pair.of((Object)StructurePoolElement.legacy((String)BiomesWeveGone.id("village/" + id).toString(), BWGVillageTemplatePools.getProcessor(context, processorList)), (Object)weight);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> singlePoolElement(String id) {
        return BWGVillageTemplatePools.singlePoolElement(id, 1);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> singlePoolElement(String id, int weight) {
        return Pair.of((Object)StructurePoolElement.single((String)BiomesWeveGone.id("village/" + id).toString()), (Object)weight);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> singlePoolElement(String id, BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureProcessorList> processorList) {
        return BWGVillageTemplatePools.singlePoolElement(id, 1, context, processorList);
    }

    private static Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> singlePoolElement(String id, int weight, BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureProcessorList> processorList) {
        return Pair.of((Object)StructurePoolElement.single((String)BiomesWeveGone.id("village/" + id).toString(), BWGVillageTemplatePools.getProcessor(context, processorList)), (Object)weight);
    }

    private static StructureTemplatePool createTemplatePool(Holder<StructureTemplatePool> fallback, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> rawTemplateFactories, StructureTemplatePool.Projection projection) {
        return new StructureTemplatePool(fallback, rawTemplateFactories, projection);
    }

    private static Holder.Reference<StructureTemplatePool> getEmptyPool(BootstrapContext<StructureTemplatePool> context) {
        return BWGVillageTemplatePools.getPool(context, (ResourceKey<StructureTemplatePool>)Pools.EMPTY);
    }

    private static Holder.Reference<StructureTemplatePool> getPool(BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureTemplatePool> poolResourceKey) {
        return context.lookup(Registries.TEMPLATE_POOL).getOrThrow(poolResourceKey);
    }

    private static Holder.Reference<StructureProcessorList> getProcessor(BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureProcessorList> processorList) {
        return context.lookup(Registries.PROCESSOR_LIST).getOrThrow(processorList);
    }

    private static ResourceKey<StructureTemplatePool> createTerminatorPool(String id) {
        return BWGVillageTemplatePools.register(id + "/terminators", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.legacyPoolElement(id + "/terminators/" + id + "_terminator_01"), BWGVillageTemplatePools.legacyPoolElement(id + "/terminators/" + id + "_terminator_02")), StructureTemplatePool.Projection.TERRAIN_MATCHING));
    }

    private static ResourceKey<StructureTemplatePool> createTerminatorPool(String id, ResourceKey<StructureProcessorList> processorList) {
        return BWGVillageTemplatePools.register(id + "/terminators", templatePoolFactoryContext -> BWGVillageTemplatePools.createTemplatePool(BWGVillageTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(BWGVillageTemplatePools.legacyPoolElement(id + "/terminators/" + id + "_terminator_01", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, processorList), BWGVillageTemplatePools.legacyPoolElement(id + "/terminators/" + id + "_terminator_02", (BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, processorList)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
    }

    private static ResourceKey<StructureTemplatePool> register(String id, BWGTemplatePools.TemplatePoolFactory factory) {
        ResourceKey templatePoolResourceKey = BiomesWeveGone.key(Registries.TEMPLATE_POOL, "village/" + id);
        BWGTemplatePools.TEMPLATE_POOL_FACTORIES.put(templatePoolResourceKey, factory);
        return templatePoolResourceKey;
    }

    public static void villageTemplatePools() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biome's We've Gone Village Template Pools");
    }
}

