/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.blockpredicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.potionstudios.biomeswevegone.world.level.levelgen.blockpredicates.BWGBlockPredicateTypes;
import org.jetbrains.annotations.NotNull;

public class RandomChancePredicate
implements BlockPredicate {
    public static final MapCodec<RandomChancePredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FloatProvider.CODEC.fieldOf("chance").forGetter(randomChancePredicate -> randomChancePredicate.chance)).apply((Applicative)instance, RandomChancePredicate::new));
    private final FloatProvider chance;

    public RandomChancePredicate(FloatProvider chance) {
        this.chance = chance;
    }

    @NotNull
    public BlockPredicateType<?> type() {
        return BWGBlockPredicateTypes.RANDOM_CHANCE.get();
    }

    public boolean test(WorldGenLevel level, BlockPos blockPos) {
        XoroshiroRandomSource xoroshiroRandomSource = new XoroshiroRandomSource(blockPos.asLong() + level.getSeed());
        return xoroshiroRandomSource.nextDouble() < (double)this.chance.sample((RandomSource)xoroshiroRandomSource);
    }
}

