/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.cattail;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class CattailPlantBlock
extends DoublePlantBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Supplier<Supplier<Item>> sprout;

    public CattailPlantBlock(BlockBehaviour.Properties properties, Supplier<Supplier<Item>> sprout) {
        super(properties);
        this.sprout = sprout;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public CattailPlantBlock(Supplier<Supplier<Item>> sprout) {
        this(BlockBehaviour.Properties.of().noCollission().noCollission().sound(SoundType.WET_GRASS).strength(0.0f), sprout);
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)HALF);
        if (half.equals((Object)DoubleBlockHalf.UPPER) && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return false;
        }
        if (half.equals((Object)DoubleBlockHalf.LOWER)) {
            BlockPos groundPos = pos.below();
            boolean water = level.getFluidState(pos).is(FluidTags.WATER);
            if (!water) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!level.getFluidState(groundPos.relative(direction)).is(FluidTags.WATER)) continue;
                    water = true;
                    break;
                }
            }
            BlockState ground = level.getBlockState(groundPos);
            return water && (ground.is(BlockTags.SAND) || ground.is(BlockTags.DIRT) || ground.is(Blocks.CLAY));
        }
        return super.canSurvive(state, level, pos);
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.setBlockAndUpdate(pos, Fluids.WATER.defaultFluidState().createLegacyBlock());
            } else {
                level.destroyBlock(pos, false);
            }
        }
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.sprout.get().get().getDefaultInstance();
    }

    public BlockItem getSprout() {
        return (BlockItem)this.sprout.get().get();
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, WATERLOGGED});
    }
}

