/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.surfacerules.BandsContext;
import net.potionstudios.biomeswevegone.world.level.levelgen.surfacerules.BandsRuleSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SurfaceSystem.class})
public abstract class SurfaceSystemMixin
implements BandsContext {
    @Unique
    private final Map<BandsRuleSource, BlockState[]> bandsLookup = new Reference2ObjectOpenHashMap();
    @Shadow
    @Final
    public PositionalRandomFactory noiseRandom;
    @Shadow
    @Final
    private NormalNoise surfaceSecondaryNoise;

    @Shadow
    protected abstract void erodedBadlandsExtension(BlockColumn var1, int var2, int var3, int var4, LevelHeightAccessor var5);

    @Inject(method={"buildSurface(Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/biome/BiomeManager;Lnet/minecraft/core/Registry;ZLnet/minecraft/world/level/levelgen/WorldGenerationContext;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/world/level/levelgen/NoiseChunk;Lnet/minecraft/world/level/levelgen/SurfaceRules$RuleSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ChunkAccess;getHeight(Lnet/minecraft/world/level/levelgen/Heightmap$Types;II)I", ordinal=1)})
    private void injectShatteredGlacierExtension(RandomState randomState, BiomeManager biomeManager, Registry<Biome> biomes, boolean useLegacyRandomSource, WorldGenerationContext context, ChunkAccess chunk, NoiseChunk noiseChunk, SurfaceRules.RuleSource ruleSource, CallbackInfo ci, @Local BlockColumn blockColumn, @Local(ordinal=4) int m, @Local(ordinal=5) int n, @Local(ordinal=6) int o, @Local Holder<Biome> holder) {
        if (holder.is(BWGBiomes.SHATTERED_GLACIER) || holder.is(BWGBiomes.ERODED_BOREALIS)) {
            this.erodedBadlandsExtension(blockColumn, m, n, o, (LevelHeightAccessor)chunk);
        }
    }

    @Override
    public BlockState getBandsState(BandsRuleSource bandsRuleSource, SimpleWeightedRandomList<BlockState> bandStates, IntProvider bandSizeProvider, IntProvider bandsCountProvider, int x, int y, int z, float frequency, int noiseScale) {
        BlockState[] blockStates = this.bandsLookup.computeIfAbsent(bandsRuleSource, key -> {
            ArrayList<BlockState> states = new ArrayList<BlockState>();
            RandomSource random = this.noiseRandom.at(BlockPos.ZERO);
            int bandsCount = bandsCountProvider.sample(random);
            for (int bandIdx = 0; bandIdx < bandsCount; ++bandIdx) {
                int bandSize = bandSizeProvider.sample(random);
                BlockState state = (BlockState)bandStates.getRandomValue(random).orElseThrow();
                for (int size = 0; size < bandSize; ++size) {
                    states.add(state);
                }
            }
            return states.toArray(new BlockState[0]);
        });
        double scaledNoise = this.surfaceSecondaryNoise.getValue((double)((float)x * frequency), 0.0, (double)((float)z * frequency)) * (double)noiseScale;
        int stateIndex = Math.floorMod((long)y + Math.round(scaledNoise), blockStates.length - 1);
        return blockStates[stateIndex];
    }
}

