/*
 * Decompiled with CFR 0.152.
 */
package fuzs.netherchested.world.level.block;

import fuzs.limitlesscontainers.api.limitlesscontainers.v1.LimitlessContainerSynchronizer;
import fuzs.limitlesscontainers.api.limitlesscontainers.v1.LimitlessContainerUtils;
import fuzs.limitlesscontainers.api.limitlesscontainers.v1.MultipliedContainer;
import fuzs.netherchested.NetherChested;
import fuzs.netherchested.config.ServerConfig;
import fuzs.netherchested.init.ModRegistry;
import fuzs.netherchested.world.level.block.entity.NetherChestBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NetherChestBlock
extends EnderChestBlock
implements TickingEntityBlock<NetherChestBlockEntity> {
    public NetherChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(Proxy.INSTANCE.splitTooltipLines(this.getDescriptionComponent()));
    }

    public Component getDescriptionComponent() {
        return Component.translatable((String)(this.getDescriptionId() + ".description")).withStyle(ChatFormatting.GOLD);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof NetherChestBlockEntity) {
                NetherChestBlockEntity blockEntity2 = (NetherChestBlockEntity)blockEntity;
                LimitlessContainerUtils.dropContents((Level)level, (BlockPos)pos, (Container)blockEntity2.getContainer());
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NetherChestBlockEntity) {
            NetherChestBlockEntity blockEntity2 = (NetherChestBlockEntity)blockEntity;
            return LimitlessContainerUtils.getRedstoneSignalFromContainer((MultipliedContainer)blockEntity2.getContainer());
        }
        return 0;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            MenuProvider menuProvider;
            BlockPos above = pos.above();
            if (level.dimension() == Level.NETHER && ((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).explodeInNether) {
                level.removeBlock(pos, false);
                Vec3 center = pos.getCenter();
                level.explode(null, level.damageSources().badRespawnPointExplosion(center), null, center, (float)((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).netherExplosionStrength, true, Level.ExplosionInteraction.BLOCK);
            } else if (!(((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).noBlockAbove && level.getBlockState(above).isRedstoneConductor((BlockGetter)level, above) || (menuProvider = this.getMenuProvider(state, level, pos)) == null)) {
                LimitlessContainerSynchronizer.setSynchronizerFor((ServerPlayer)((ServerPlayer)player), (int)player.openMenu(menuProvider).orElse(-1));
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return super.newBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return super.getTicker(level, state, blockEntityType);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!(state.hasProperty((Property)WATERLOGGED) && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() || random.nextInt(2) != 0)) {
            double posX = (double)pos.getX() + 0.5 + 0.4375 * (double)(random.nextInt(2) * 2 - 1);
            double posY = (float)pos.getY() + random.nextFloat();
            double posZ = (double)pos.getZ() + 0.5 + 0.4375 * (double)(random.nextInt(2) * 2 - 1);
            double ySpeed = (double)random.nextFloat() * 0.015625;
            if (random.nextInt(7) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, posX, posY, posZ, 0.0, ySpeed * 4.0, 0.0);
            } else {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, posX, posY, posZ, 0.0, ySpeed, 0.0);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NetherChestBlockEntity) {
            NetherChestBlockEntity blockEntity2 = (NetherChestBlockEntity)blockEntity;
            blockEntity2.recheckOpen();
        }
    }

    public BlockEntityType<? extends NetherChestBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.NETHER_CHEST_BLOCK_ENTITY_TYPE.value();
    }
}

