/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.tools.ItemArmor;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ModArmorMaterial;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemShockwaveCreator
extends ItemImpl
implements ITrinketItem {
    public ItemShockwaveCreator() {
        super("shockwave_creator", new Item.Properties().stacksTo(1));
    }

    public void inventoryTick(ItemStack stack, Level levelIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (levelIn.isClientSide || !(entityIn instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entityIn;
        if (!living.onGround()) {
            if (stack.has(Data.TYPE) && ((Data)stack.get(Data.TYPE)).air) {
                return;
            }
            stack.set(Data.TYPE, (Object)new Data(true, living.getX(), living.getY(), living.getZ()));
        } else {
            BlockPos pos;
            BlockPos down;
            BlockState downState;
            if (!stack.has(Data.TYPE)) {
                return;
            }
            Data data = (Data)stack.get(Data.TYPE);
            if (!data.air) {
                return;
            }
            stack.remove(Data.TYPE);
            if (!living.isShiftKeyDown()) {
                return;
            }
            if (living.distanceToSqr(data.x, data.y, data.z) > 0.75) {
                return;
            }
            if (living instanceof Player && !NaturesAuraAPI.instance().extractAuraFromPlayer((Player)living, 1000, false)) {
                return;
            }
            boolean infusedSet = ItemArmor.isFullSetEquipped(living, (ArmorMaterial)ModArmorMaterial.INFUSED.material.value());
            int range = 5;
            List mobs = levelIn.getEntitiesOfClass(LivingEntity.class, new AABB(living.getX() - (double)range, living.getY() - 0.5, living.getZ() - (double)range, living.getX() + (double)range, living.getY() + 0.5, living.getZ() + (double)range));
            for (LivingEntity mob : mobs) {
                if (!mob.isAlive() || mob == living || living.distanceToSqr((Entity)mob) > (double)(range * range)) continue;
                if (living instanceof Player && !NaturesAuraAPI.instance().extractAuraFromPlayer((Player)living, 500, false)) break;
                DamageSource source = living instanceof Player ? mob.damageSources().playerAttack((Player)living) : mob.damageSources().magic();
                mob.hurt(source, 4.0f);
                if (!infusedSet) continue;
                mob.addEffect(new MobEffectInstance(MobEffects.WITHER, 120));
            }
            if (!(downState = levelIn.getBlockState(down = (pos = living.blockPosition()).below())).isAir()) {
                SoundType type = downState.getBlock().getSoundType(downState, (LevelReader)levelIn, down, null);
                levelIn.playSound(null, pos, type.getBreakSound(), SoundSource.BLOCKS, type.getVolume() * 0.5f, type.getPitch() * 0.8f);
            }
            PacketHandler.sendToAllAround(levelIn, pos, 32, new PacketParticles((float)living.getX(), (float)living.getY(), (float)living.getZ(), PacketParticles.Type.SHOCKWAVE_CREATOR, new int[0]));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(ItemStack stack, Player player, ITrinketItem.RenderType type, PoseStack matrices, MultiBufferSource buffer, int packedLight, boolean isHolding) {
        if (type == ITrinketItem.RenderType.BODY && !isHolding) {
            boolean armor = !((ItemStack)player.getInventory().armor.get(EquipmentSlot.CHEST.getIndex())).isEmpty();
            matrices.translate(0.0f, 0.125f, armor ? -0.195f : -0.1475f);
            matrices.scale(0.3f, 0.3f, 0.3f);
            matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, matrices, buffer, player.level(), 0);
        }
    }

    public record Data(boolean air, double x, double y, double z) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("air").forGetter(d -> d.air), (App)Codec.DOUBLE.fieldOf("x").forGetter(d -> d.x), (App)Codec.DOUBLE.fieldOf("y").forGetter(d -> d.y), (App)Codec.DOUBLE.fieldOf("z").forGetter(d -> d.z)).apply((Applicative)i, Data::new));
        public static final DataComponentType<Data> TYPE = DataComponentType.builder().persistent(CODEC).cacheEncoding().build();
    }
}

