/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.items.ItemImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;

public class ItemLootFinder
extends ItemImpl {
    public ItemLootFinder() {
        super("loot_finder");
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        NaturesAuraAPI.IInternalHooks inst = NaturesAuraAPI.instance();
        if (!inst.extractAuraFromPlayer(playerIn, 100000, false)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (levelIn.isClientSide) {
            inst.setParticleDepth(false);
            inst.setParticleSpawnRange(64);
            inst.setParticleCulling(false);
            BlockPos pos = playerIn.blockPosition();
            Helper.getBlockEntitiesInArea((LevelAccessor)levelIn, pos, 64, tile -> {
                if (tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, null) != null || tile instanceof SpawnerBlockEntity || BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)tile.getType()).getNamespace().equals("lootr")) {
                    inst.spawnMagicParticle((float)tile.getBlockPos().getX() + 0.5f, (float)tile.getBlockPos().getY() + 0.5f, (float)tile.getBlockPos().getZ() + 0.5f, 0.0, 0.0, 0.0, 16118026, 6.0f, 1200, 0.0f, false, true);
                }
                return false;
            });
            for (Entity entity : levelIn.getEntitiesOfClass(Entity.class, new AABB(pos).inflate(64.0))) {
                if (entity instanceof LivingEntity || entity.getCapability(Capabilities.ItemHandler.ENTITY) == null) continue;
                inst.spawnMagicParticle(entity.getX(), entity.getEyeY(), entity.getZ(), 0.0, 0.0, 0.0, 16118026, 6.0f, 1200, 0.0f, false, true);
            }
            inst.setParticleDepth(true);
            inst.setParticleSpawnRange(32);
            inst.setParticleCulling(true);
            playerIn.swing(handIn);
        }
        playerIn.getCooldowns().addCooldown((Item)this, 1200);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

