/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityLightProjectile
extends ThrowableProjectile {
    public EntityLightProjectile(EntityType<? extends ThrowableProjectile> type, Level levelIn) {
        super(type, levelIn);
    }

    public EntityLightProjectile(EntityType<? extends ThrowableProjectile> type, LivingEntity livingEntityIn, Level levelIn) {
        super(type, livingEntityIn, levelIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.tickCount > 1) {
            for (float i = 0.0f; i <= 1.0f; i += 0.2f) {
                NaturesAuraAPI.instance().spawnMagicParticle(Mth.lerp((double)i, (double)this.xOld, (double)this.getX()), Mth.lerp((double)i, (double)this.yOld, (double)this.getY()), Mth.lerp((double)i, (double)this.zOld, (double)this.getZ()), this.random.nextGaussian() * (double)0.01f, this.random.nextGaussian() * (double)0.01f, this.random.nextGaussian() * (double)0.01f, 16763740, this.random.nextFloat() * 0.5f + 1.0f, 20, 0.0f, false, true);
            }
        }
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            if (result instanceof BlockHitResult) {
                BlockHitResult res = (BlockHitResult)result;
                BlockPos pos = res.getBlockPos().relative(res.getDirection());
                BlockState state = this.level().getBlockState(pos);
                if (state.canBeReplaced()) {
                    this.level().setBlockAndUpdate(pos, ModBlocks.LIGHT.defaultBlockState());
                }
            } else if (result instanceof EntityHitResult) {
                EntityHitResult entity = (EntityHitResult)result;
                entity.getEntity().setRemainingFireTicks(100);
            }
        }
        this.discard();
    }
}

