/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import com.google.common.primitives.Ints;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlockEntityFireworkGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private FireworkRocketEntity trackedEntity;
    private ItemStack trackedItem;
    private int toRelease;
    private int releaseTimer;

    public BlockEntityFireworkGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FIREWORK_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            if (this.level.getGameTime() % 10L == 0L) {
                List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition).inflate(4.0), Entity::isAlive);
                for (ItemEntity item : items) {
                    ItemStack stack;
                    if (item.hasPickUpDelay() || (stack = item.getItem()).isEmpty() || stack.getItem() != Items.FIREWORK_ROCKET) continue;
                    if (this.trackedEntity == null && this.releaseTimer <= 0) {
                        FireworkRocketEntity entity;
                        this.trackedEntity = entity = new FireworkRocketEntity(this.level, item.getX(), item.getY(), item.getZ(), stack);
                        this.trackedItem = stack.copy();
                        this.level.addFreshEntity((Entity)entity);
                    }
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        item.kill();
                        continue;
                    }
                    item.setItem(stack);
                }
            }
            if (this.trackedEntity != null && !this.trackedEntity.isAlive()) {
                if (this.trackedItem.has(DataComponents.FIREWORKS)) {
                    float generateFactor = 0.0f;
                    HashSet<Integer> usedColors = new HashSet<Integer>();
                    Fireworks fireworks = (Fireworks)this.trackedItem.get(DataComponents.FIREWORKS);
                    int flightTime = fireworks.flightDuration();
                    List explosions = fireworks.explosions();
                    if (!explosions.isEmpty()) {
                        generateFactor += (float)flightTime;
                        for (FireworkExplosion explosion : explosions) {
                            boolean trail;
                            generateFactor += 1.5f;
                            boolean flicker = explosion.hasTwinkle();
                            if (flicker) {
                                generateFactor += 1.0f;
                            }
                            if (trail = explosion.hasTrail()) {
                                generateFactor += 8.0f;
                            }
                            FireworkExplosion.Shape type = explosion.shape();
                            generateFactor += (new float[]{0.0f, 1.0f, 0.5f, 20.0f, 0.5f})[type.getId()];
                            HashSet<Integer> colors = new HashSet<Integer>();
                            for (Integer color : explosion.colors()) {
                                usedColors.add(color);
                                colors.add(color);
                            }
                            generateFactor += 0.75f * (float)colors.size();
                        }
                    }
                    if (generateFactor > 0.0f) {
                        int toAdd = Mth.ceil((float)(generateFactor * 10000.0f));
                        if (this.canGenerateRightNow(toAdd)) {
                            this.toRelease = toAdd;
                            this.releaseTimer = 15 * flightTime + 40;
                        }
                        ArrayList<Integer> data = new ArrayList<Integer>();
                        data.add(this.worldPosition.getX());
                        data.add(this.worldPosition.getY());
                        data.add(this.worldPosition.getZ());
                        data.addAll(usedColors);
                        PacketHandler.sendToAllLoaded(this.level, this.worldPosition, new PacketParticles((float)this.trackedEntity.getX(), (float)this.trackedEntity.getY(), (float)this.trackedEntity.getZ(), PacketParticles.Type.FIREWORK_GEN, Ints.toArray(data)));
                    }
                }
                this.trackedEntity = null;
                this.trackedItem = null;
            }
            if (this.releaseTimer > 0) {
                --this.releaseTimer;
                if (this.releaseTimer <= 0) {
                    this.generateAura(this.toRelease);
                    this.toRelease = 0;
                    PacketHandler.sendToAllLoaded(this.level, this.worldPosition, new PacketParticles((float)this.worldPosition.getX(), (float)this.worldPosition.getY(), (float)this.worldPosition.getZ(), PacketParticles.Type.FLOWER_GEN_AURA_CREATION, new int[0]));
                }
            }
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }
}

