/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BlockEntityFieldCreator
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockPos connectionOffset;
    public boolean isMain;
    public boolean isCharged;
    private int chargeTimer;

    public BlockEntityFieldCreator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FIELD_CREATOR, pos, state);
    }

    @Override
    public void tick() {
        BlockEntityFieldCreator creator;
        BlockPos connectedPos;
        block15: {
            block14: {
                if (this.level.isClientSide || this.level.getGameTime() % 10L != 0L) {
                    return;
                }
                connectedPos = this.getConnectedPos();
                if (connectedPos == null || !this.level.isLoaded(connectedPos)) {
                    return;
                }
                BlockEntity other = this.level.getBlockEntity(connectedPos);
                if (!this.isCloseEnough(connectedPos) || !(other instanceof BlockEntityFieldCreator)) break block14;
                creator = (BlockEntityFieldCreator)other;
                if (this.worldPosition.equals((Object)((BlockEntityFieldCreator)other).getConnectedPos())) break block15;
            }
            this.connectionOffset = null;
            this.chargeTimer = 0;
            this.isCharged = false;
            this.isMain = false;
            this.sendToClients();
            return;
        }
        if (!this.isMain) {
            return;
        }
        if (this.redstonePower <= 0 && creator.redstonePower <= 0 || !this.canUseRightNow(20)) {
            this.chargeTimer = 0;
            if (this.isCharged) {
                this.isCharged = false;
                this.sendToClients();
                creator.isCharged = false;
                creator.sendToClients();
            }
            return;
        }
        BlockPos spot = IAuraChunk.getHighestSpot(this.level, this.worldPosition, 32, this.worldPosition);
        IAuraChunk chunk = IAuraChunk.getAuraChunk(this.level, spot);
        if (!this.isCharged) {
            this.chargeTimer += 10;
            if (this.chargeTimer >= 150) {
                this.chargeTimer = 0;
                this.isCharged = true;
                this.sendToClients();
                creator.isCharged = true;
                creator.sendToClients();
            }
            chunk.drainAura(spot, 300);
            this.sendParticles();
        } else {
            if (this.level.getGameTime() % 40L == 0L) {
                chunk.drainAura(spot, 20);
            }
            ItemStack tool = this.getToolUsed(creator);
            Vec3 dist = new Vec3((double)(this.worldPosition.getX() - connectedPos.getX()), (double)(this.worldPosition.getY() - connectedPos.getY()), (double)(this.worldPosition.getZ() - connectedPos.getZ()));
            double length = dist.length();
            Vec3 normal = new Vec3(dist.x / length, dist.y / length, dist.z / length);
            for (float i = (float)Mth.floor((double)length); i > 0.0f; i -= 0.5f) {
                FakePlayer fake;
                BlockState state;
                Vec3 scaled = normal.scale((double)i);
                BlockPos pos = connectedPos.offset(Mth.floor((double)(scaled.x + 0.5)), Mth.floor((double)(scaled.y + 0.5)), Mth.floor((double)(scaled.z + 0.5)));
                if (pos.equals((Object)this.worldPosition) || pos.equals((Object)connectedPos) || (state = this.level.getBlockState(pos)).isAir() || !(state.getDestroySpeed((BlockGetter)this.level, pos) >= 0.0f) || ((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.level, pos, state, (Player)(fake = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.level)))))).isCanceled()) continue;
                List drops = state.getDrops(new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.THIS_ENTITY, (Object)fake).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.TOOL, (Object)(tool.isEmpty() ? new ItemStack((ItemLike)Items.DIAMOND_PICKAXE) : tool)).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)this.level.getBlockEntity(pos)));
                this.level.destroyBlock(pos, false);
                for (ItemStack stack : drops) {
                    Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)stack);
                }
                chunk.drainAura(spot, !tool.isEmpty() ? 300 : 100);
                this.sendParticles();
            }
        }
    }

    private ItemStack getToolUsed(BlockEntityFieldCreator other) {
        ItemStack myTool = this.getMyTool();
        ItemStack otherTool = other.getMyTool();
        if (!myTool.isEmpty()) {
            if (!otherTool.isEmpty()) {
                return this.level.random.nextBoolean() ? myTool : otherTool;
            }
            return myTool;
        }
        return otherTool;
    }

    private ItemStack getMyTool() {
        List<ItemFrame> frames = Helper.getAttachedItemFrames(this.level, this.worldPosition);
        for (ItemFrame frame : frames) {
            ItemStack stack = frame.getItem();
            if (stack.isEmpty()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private void sendParticles() {
        for (int j = 0; j < 2; ++j) {
            BlockPos p = j == 0 ? this.worldPosition : this.getConnectedPos();
            PacketHandler.sendToAllAround(this.level, p, 32, new PacketParticleStream((float)p.getX() + (float)this.level.random.nextGaussian() * 3.0f, (float)(p.getY() + 1) + this.level.random.nextFloat() * 3.0f, (float)p.getZ() + (float)this.level.random.nextGaussian() * 3.0f, (float)p.getX() + 0.5f, (float)p.getY() + 0.5f, (float)p.getZ() + 0.5f, this.level.random.nextFloat() * 0.07f + 0.07f, IAuraType.forLevel(this.level).getColor(), this.level.random.nextFloat() + 0.5f));
        }
    }

    public boolean isCloseEnough(BlockPos pos) {
        int range = (Integer)ModConfig.instance.fieldCreatorRange.get() + 1;
        return this.worldPosition.distSqr((Vec3i)pos) <= (double)(range * range);
    }

    public BlockPos getConnectedPos() {
        if (this.connectionOffset == null) {
            return null;
        }
        return this.worldPosition.offset((Vec3i)this.connectionOffset);
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.writeNBT(compound, type, registries);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            if (this.connectionOffset != null) {
                compound.putLong("connection", this.connectionOffset.asLong());
            }
            compound.putBoolean("main", this.isMain);
            compound.putBoolean("charged", this.isCharged);
            if (type == BlockEntityImpl.SaveType.TILE) {
                compound.putInt("timer", this.chargeTimer);
            }
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.readNBT(compound, type, registries);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.connectionOffset = compound.contains("connection") ? BlockPos.of((long)compound.getLong("connection")) : null;
            this.isMain = compound.getBoolean("main");
            this.isCharged = compound.getBoolean("charged");
            if (type == BlockEntityImpl.SaveType.TILE) {
                this.chargeTimer = compound.getInt("timer");
            }
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

