/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityChorusGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private final Deque<BlockPos> currentlyBreaking = new ArrayDeque<BlockPos>();
    private int auraPerBlock;

    public BlockEntityChorusGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CHORUS_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        if (this.level.getGameTime() % 5L != 0L) {
            return;
        }
        if (this.currentlyBreaking.isEmpty()) {
            return;
        }
        BlockPos pos = this.currentlyBreaking.removeLast();
        BlockState state = this.level.getBlockState(pos);
        if (state.getBlock() != Blocks.CHORUS_PLANT && state.getBlock() != Blocks.CHORUS_FLOWER) {
            this.currentlyBreaking.clear();
            return;
        }
        PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles((float)this.worldPosition.getX(), (float)this.worldPosition.getY(), (float)this.worldPosition.getZ(), PacketParticles.Type.CHORUS_GENERATOR, pos.getX(), pos.getY(), pos.getZ()));
        this.level.removeBlock(pos, false);
        this.level.playSound(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.generateAura(this.auraPerBlock);
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        if (this.redstonePower <= 0 && newPower > 0 && this.currentlyBreaking.isEmpty()) {
            int range = 2;
            block0: for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockState state;
                        BlockPos offset = this.worldPosition.offset(x, y, z);
                        BlockState below = this.level.getBlockState(offset.below());
                        if (below.getBlock() != Blocks.END_STONE || (state = this.level.getBlockState(offset)).getBlock() != Blocks.CHORUS_PLANT) continue;
                        ArrayList<BlockPos> plants = new ArrayList<BlockPos>();
                        this.collectChorusPlant(offset, plants);
                        if (plants.size() <= 1) continue;
                        this.currentlyBreaking.addAll(plants);
                        this.currentlyBreaking.addFirst(offset);
                        int aura = plants.size() * plants.size() * 300;
                        this.auraPerBlock = aura / plants.size();
                        break block0;
                    }
                }
            }
        }
        super.onRedstonePowerChange(newPower);
    }

    private void collectChorusPlant(BlockPos pos, List<BlockPos> blocks) {
        for (Direction dir : Direction.values()) {
            BlockState state;
            BlockPos offset;
            if (dir == Direction.DOWN || blocks.contains(offset = pos.relative(dir)) || (state = this.level.getBlockState(offset)).getBlock() != Blocks.CHORUS_PLANT && state.getBlock() != Blocks.CHORUS_FLOWER) continue;
            blocks.add(offset);
            this.collectChorusPlant(offset, blocks);
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.writeNBT(compound, type, registries);
        if (type == BlockEntityImpl.SaveType.TILE) {
            ListTag list = new ListTag();
            for (BlockPos pos : this.currentlyBreaking) {
                list.add((Object)NbtUtils.writeBlockPos((BlockPos)pos));
            }
            compound.put("breaking", (Tag)list);
            compound.putInt("aura", this.auraPerBlock);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.readNBT(compound, type, registries);
        if (type == BlockEntityImpl.SaveType.TILE) {
            this.currentlyBreaking.clear();
            ListTag list = compound.getList("breaking", 11);
            for (Tag tag : list) {
                this.currentlyBreaking.add(Helper.readBlockPos(tag));
            }
            this.auraPerBlock = compound.getInt("aura");
        }
    }
}

