/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityProjectileGenerator;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderProjectileGenerator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

public class BlockProjectileGenerator
extends BlockContainerImpl
implements ITESRProvider<BlockEntityProjectileGenerator>,
ICustomBlockState {
    public BlockProjectileGenerator() {
        super("projectile_generator", BlockEntityProjectileGenerator.class, BlockBehaviour.Properties.of().strength(2.5f).sound(SoundType.STONE));
        NeoForge.EVENT_BUS.register((Object)this);
        DispenserBlock.registerBehavior((ItemLike)Items.ENDER_PEARL, (DispenseItemBehavior)new DefaultDispenseItemBehavior(this){

            protected ItemStack execute(BlockSource blockSource, ItemStack item) {
                ServerLevel level = blockSource.level();
                Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                Position position = ProjectileItem.DispenseConfig.DEFAULT.positionFunction().getDispensePosition(blockSource, direction);
                ThrownEnderpearl projectile = new ThrownEnderpearl(EntityType.ENDER_PEARL, (Level)level);
                projectile.setPos(position.x(), position.y(), position.z());
                projectile.shoot((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ(), ProjectileItem.DispenseConfig.DEFAULT.power(), ProjectileItem.DispenseConfig.DEFAULT.uncertainty());
                level.addFreshEntity((Entity)projectile);
                item.shrink(1);
                return item;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.TRIDENT, (DispenseItemBehavior)new DefaultDispenseItemBehavior(this){

            protected ItemStack execute(BlockSource blockSource, ItemStack item) {
                ServerLevel level = blockSource.level();
                Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                Position position = ProjectileItem.DispenseConfig.DEFAULT.positionFunction().getDispensePosition(blockSource, direction);
                ThrownTrident projectile = new ThrownTrident(EntityType.TRIDENT, (Level)level);
                ObfuscationReflectionHelper.setPrivateValue(ThrownTrident.class, (Object)projectile, (Object)item.copy(), (String)"pickupItemStack");
                projectile.pickup = AbstractArrow.Pickup.ALLOWED;
                projectile.setPos(position.x(), position.y(), position.z());
                projectile.shoot((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ(), ProjectileItem.DispenseConfig.DEFAULT.power(), ProjectileItem.DispenseConfig.DEFAULT.uncertainty());
                level.addFreshEntity((Entity)projectile);
                item.shrink(1);
                return item;
            }
        });
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        HitResult ray = event.getRayTraceResult();
        if (!(ray instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockRay = (BlockHitResult)ray;
        BlockPos pos = blockRay.getBlockPos();
        if (pos == null) {
            return;
        }
        BlockEntity tile = entity.level().getBlockEntity(pos);
        if (!(tile instanceof BlockEntityProjectileGenerator)) {
            return;
        }
        BlockEntityProjectileGenerator generator = (BlockEntityProjectileGenerator)tile;
        if (generator.nextSide != blockRay.getDirection()) {
            return;
        }
        Integer amount = NaturesAuraAPI.PROJECTILE_GENERATIONS.get(entity.getType());
        if (amount == null || amount <= 0) {
            return;
        }
        if (!generator.canGenerateRightNow(amount)) {
            return;
        }
        generator.generateAura(amount);
        PacketHandler.sendToAllAround(entity.level(), pos, 32, new PacketParticles((float)entity.getX(), (float)entity.getY(), (float)entity.getZ(), PacketParticles.Type.PROJECTILE_GEN, pos.getX(), pos.getY(), pos.getZ()));
        entity.level().playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.BLOCKS, 0.8f, 1.0f);
        generator.nextSide = generator.nextSide.getClockWise();
        generator.sendToClients();
        entity.kill();
        event.setCanceled(true);
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_top"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }

    @Override
    public void registerTESR() {
        BlockEntityRenderers.register(ModBlockEntities.PROJECTILE_GENERATOR, RenderProjectileGenerator::new);
    }
}

