/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityGratedChute;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class BlockGratedChute
extends BlockContainerImpl
implements ICustomBlockState,
ICustomItemModel {
    public static final DirectionProperty FACING = HopperBlock.FACING;
    private static final VoxelShape INSIDE = Block.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape INPUT_SHAPE = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = Shapes.or((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape COMBINED_SHAPE = Shapes.join((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)INSIDE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape DOWN_SHAPE = Shapes.or((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.box((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.box((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.box((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.box((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = INSIDE;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    public BlockGratedChute() {
        super("grated_chute", BlockEntityGratedChute.class, BlockBehaviour.Properties.of().strength(3.0f, 8.0f).sound(SoundType.METAL));
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.DOWN -> DOWN_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> COMBINED_SHAPE;
        };
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter levelIn, BlockPos pos) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.DOWN -> DOWN_RAYTRACE_SHAPE;
            case Direction.NORTH -> NORTH_RAYTRACE_SHAPE;
            case Direction.SOUTH -> SOUTH_RAYTRACE_SHAPE;
            case Direction.WEST -> WEST_RAYTRACE_SHAPE;
            case Direction.EAST -> EAST_RAYTRACE_SHAPE;
            default -> INSIDE;
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (!(tile instanceof BlockEntityGratedChute)) {
            return InteractionResult.FAIL;
        }
        BlockEntityGratedChute chute = (BlockEntityGratedChute)tile;
        if (!level.isClientSide) {
            chute.isBlacklist = !chute.isBlacklist;
            chute.sendToClients();
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction newFacing = context.getClickedFace().getOpposite();
        if (newFacing == Direction.UP) {
            newFacing = Direction.DOWN;
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)newFacing);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level levelIn, BlockPos pos) {
        BlockEntity tile = levelIn.getBlockEntity(pos);
        if (tile instanceof BlockEntityGratedChute) {
            IItemHandler handler = (IItemHandler)levelIn.getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, null);
            ItemStack stack = handler.getStackInSlot(0);
            if (stack.isEmpty()) {
                return 0;
            }
            return Mth.ceil((float)((float)stack.getCount() / (float)stack.getMaxStackSize() * 15.0f));
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        generator.withExistingParent(this.getBaseName(), generator.modLoc("block/" + this.getBaseName() + "_down"));
    }
}

