/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item.armor;

import com.blakebr0.cucumber.item.BaseArmorItem;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModDataComponentTypes;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EssenceChestplateItem
extends BaseArmorItem
implements ITinkerable {
    private static final EnumSet<AugmentType> TYPES = EnumSet.of(AugmentType.ARMOR, AugmentType.CHESTPLATE);
    private final int tinkerableTier;
    private final int slots;

    public EssenceChestplateItem(Holder<ArmorMaterial> material, int maxDamageFactor, int tinkerableTier, int slots) {
        super(material, ArmorItem.Type.CHESTPLATE, maxDamageFactor, p -> p.component(ModDataComponentTypes.EQUIPPED_AUGMENTS, new ArrayList(slots)));
        this.tinkerableTier = tinkerableTier;
        this.slots = slots;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (slot == 38 && entity instanceof Player) {
            Player player = (Player)entity;
            for (Augment augment : AugmentUtils.getAugments(stack)) {
                augment.onArmorTick(stack, level, player);
            }
            if (((Boolean)ModConfigs.AWAKENED_SUPREMIUM_SET_BONUS.get()).booleanValue() && !level.isClientSide() && level.getGameTime() % 20L == 0L && EssenceChestplateItem.hasAwakenedSupremiumSet(player)) {
                EssenceChestplateItem.handleGrowthTicks(level, player);
            }
        }
        for (Augment augment : AugmentUtils.getAugments(stack)) {
            augment.onInventoryTick(stack, level, entity, slot, isSelected);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(ModTooltips.getTooltipForTier(this.tinkerableTier));
        if (((Boolean)ModConfigs.AWAKENED_SUPREMIUM_SET_BONUS.get()).booleanValue() && stack.is((Item)ModItems.AWAKENED_SUPREMIUM_CHESTPLATE.get())) {
            tooltip.add((Component)ModTooltips.SET_BONUS.args(new Object[]{ModTooltips.AWAKENED_SUPREMIUM_SET_BONUS.build()}).build());
        }
        ModTooltips.addAugmentListToTooltip(tooltip, stack, this.slots);
    }

    @Override
    public int getAugmentSlots() {
        return this.slots;
    }

    @Override
    public EnumSet<AugmentType> getAugmentTypes() {
        return TYPES;
    }

    @Override
    public int getTinkerableTier() {
        return this.tinkerableTier;
    }

    private static boolean hasAwakenedSupremiumSet(Player player) {
        boolean helmet = player.getItemBySlot(EquipmentSlot.HEAD).is((Item)ModItems.AWAKENED_SUPREMIUM_HELMET.get());
        boolean chestplate = player.getItemBySlot(EquipmentSlot.CHEST).is((Item)ModItems.AWAKENED_SUPREMIUM_CHESTPLATE.get());
        boolean leggings = player.getItemBySlot(EquipmentSlot.LEGS).is((Item)ModItems.AWAKENED_SUPREMIUM_LEGGINGS.get());
        boolean boots = player.getItemBySlot(EquipmentSlot.FEET).is((Item)ModItems.AWAKENED_SUPREMIUM_BOOTS.get());
        return helmet && chestplate && leggings && boots;
    }

    private static void handleGrowthTicks(Level level, Player player) {
        BlockPos pos = player.getOnPos();
        int range = 5;
        BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).forEach(aoePos -> {
            if (Math.random() < 0.5) {
                return;
            }
            BlockState state = level.getBlockState(aoePos);
            if (state.is(BlockTags.CROPS)) {
                state.randomTick((ServerLevel)level, aoePos, Utils.RANDOM);
                double d0 = (float)aoePos.getX() + level.getRandom().nextFloat();
                double d1 = aoePos.getY();
                double d2 = (float)aoePos.getZ() + level.getRandom().nextFloat();
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.1);
            }
        });
    }
}

