/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;

public class MysticalFertilizerItem
extends BaseItem {
    public MysticalFertilizerItem() {
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new DispenserBehavior());
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        Level level = context.getLevel();
        Direction direction = context.getClickedFace();
        if (player == null || !player.mayUseItemAt(pos.relative(direction), direction, stack)) {
            return InteractionResult.FAIL;
        }
        if (MysticalFertilizerItem.applyFertilizer(stack, level, pos, player)) {
            if (!level.isClientSide()) {
                level.levelEvent(1505, pos, 0);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)ModTooltips.MYSTICAL_FERTILIZER.build());
    }

    public static boolean applyFertilizer(ItemStack stack, Level level, BlockPos pos, Player player) {
        BonemealableBlock growable;
        BonemealEvent event;
        BlockState state = level.getBlockState(pos);
        if (player != null && (event = EventHooks.fireBonemealEvent((Player)player, (Level)level, (BlockPos)pos, (BlockState)state, (ItemStack)stack)).isCanceled()) {
            return event.isSuccessful();
        }
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, state)) {
            if (!level.isClientSide()) {
                RandomSource rand = level.getRandom();
                if (growable.isBonemealSuccess(level, rand, pos, state) || MysticalFertilizerItem.canGrowResourceCrops(growable) || growable instanceof SaplingBlock) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    if (growable instanceof CropBlock) {
                        CropBlock crop = (CropBlock)growable;
                        level.setBlock(pos, crop.getStateForAge(crop.getMaxAge()), 2);
                    } else if (growable instanceof SaplingBlock) {
                        SaplingBlock sapling = (SaplingBlock)growable;
                        BlockGrowFeatureEvent event2 = EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)rand, (BlockPos)pos, null);
                        if (event2.isCanceled()) {
                            return false;
                        }
                        ChunkGenerator chunkGenerator = serverWorld.getChunkSource().getGenerator();
                        sapling.treeGrower.growTree(serverWorld, chunkGenerator, pos, state, rand);
                    } else {
                        growable.performBonemeal(serverWorld, rand, pos, state);
                    }
                }
                stack.shrink(1);
            }
            return true;
        }
        return false;
    }

    private static boolean canGrowResourceCrops(BonemealableBlock growable) {
        ICropProvider cropGetter;
        return growable instanceof ICropProvider && (cropGetter = (ICropProvider)growable).getCrop().getTier().isFertilizable();
    }

    public static class DispenserBehavior
    extends OptionalDispenseItemBehavior {
        protected ItemStack execute(BlockSource source, ItemStack stack) {
            this.setSuccess(true);
            ServerLevel level = source.level();
            BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            if (MysticalFertilizerItem.applyFertilizer(stack, (Level)level, pos, null)) {
                if (!level.isClientSide()) {
                    level.levelEvent(2005, pos, 0);
                }
            } else {
                this.setSuccess(false);
            }
            return stack;
        }
    }
}

