/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ingredient.IngredientWithCount;
import com.blakebr0.mysticalagriculture.api.crafting.ISouliumSpawnerRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public class SouliumSpawnerRecipe
implements ISouliumSpawnerRecipe {
    private final NonNullList<IngredientWithCount> inputs;
    private final WeightedRandomList<WeightedEntry.Wrapper<EntityType<?>>> entityTypes;

    public SouliumSpawnerRecipe(IngredientWithCount input, WeightedRandomList<WeightedEntry.Wrapper<EntityType<?>>> entityTypes) {
        this.inputs = NonNullList.of((Object)IngredientWithCount.EMPTY, (Object[])new IngredientWithCount[]{input});
        this.entityTypes = entityTypes;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        if (this.inputs.size() != inventory.ingredientCount()) {
            return false;
        }
        ItemStack stack = inventory.getItem(0);
        return ((IngredientWithCount)this.inputs.getFirst()).test(stack);
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider lookup) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs.stream().map(ICustomIngredient::toVanilla).collect(Collectors.toCollection(NonNullList::create));
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.SOULIUM_SPAWNER.get();
    }

    public RecipeType<? extends ISouliumSpawnerRecipe> getType() {
        return (RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get();
    }

    @Override
    public WeightedRandomList<WeightedEntry.Wrapper<EntityType<?>>> getEntityTypes() {
        return this.entityTypes;
    }

    @Override
    public EntityType<?> getFirstEntityType() {
        return (EntityType)((WeightedEntry.Wrapper)this.entityTypes.unwrap().getFirst()).data();
    }

    @Override
    public Optional<WeightedEntry.Wrapper<EntityType<?>>> getRandomEntityType(RandomSource random) {
        return this.entityTypes.getRandom(random);
    }

    @Override
    public int getCount(int index) {
        if (index < 0 || index >= this.inputs.size()) {
            return -1;
        }
        return ((IngredientWithCount)this.inputs.get(index)).getCount();
    }

    public static class Serializer
    implements RecipeSerializer<SouliumSpawnerRecipe> {
        private static final StreamCodec<RegistryFriendlyByteBuf, EntityType<?>> ENTITY_TYPE_STREAM_CODEC = ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE);
        public static final MapCodec<SouliumSpawnerRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IngredientWithCount.MAP_CODEC.fieldOf("input").forGetter(recipe -> (IngredientWithCount)recipe.inputs.getFirst()), (App)WeightedRandomList.codec((Codec)RecordCodecBuilder.create(wrapper -> wrapper.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(WeightedEntry.Wrapper::data), (App)Weight.CODEC.fieldOf("weight").forGetter(WeightedEntry.Wrapper::weight)).apply((Applicative)wrapper, WeightedEntry.Wrapper::new))).fieldOf("entities").forGetter(recipe -> recipe.entityTypes)).apply((Applicative)builder, SouliumSpawnerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SouliumSpawnerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SouliumSpawnerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SouliumSpawnerRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SouliumSpawnerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            IngredientWithCount input = (IngredientWithCount)IngredientWithCount.STREAM_CODEC.decode((Object)buffer);
            int entities = buffer.readVarInt();
            ArrayList<WeightedEntry.Wrapper> entityTypes = new ArrayList<WeightedEntry.Wrapper>();
            for (int i = 0; i < entities; ++i) {
                EntityType entityType = (EntityType)ENTITY_TYPE_STREAM_CODEC.decode((Object)buffer);
                int entityTypeWeight = buffer.readVarInt();
                entityTypes.add(WeightedEntry.wrap((Object)entityType, (int)entityTypeWeight));
            }
            return new SouliumSpawnerRecipe(input, WeightedRandomList.create(entityTypes));
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, SouliumSpawnerRecipe recipe) {
            IngredientWithCount.STREAM_CODEC.encode((Object)buffer, (Object)((IngredientWithCount)recipe.inputs.getFirst()));
            buffer.writeVarInt(recipe.entityTypes.unwrap().size());
            for (WeightedEntry.Wrapper entityType : recipe.entityTypes.unwrap()) {
                ENTITY_TYPE_STREAM_CODEC.encode((Object)buffer, (Object)((EntityType)entityType.data()));
                buffer.writeVarInt(entityType.weight().asInt());
            }
        }
    }
}

