/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ingredient.IngredientWithCount;
import com.blakebr0.mysticalagriculture.api.crafting.IEnchanterRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class EnchanterRecipe
implements IEnchanterRecipe {
    private final NonNullList<IngredientWithCount> inputs;
    private final Holder<Enchantment> enchantment;

    public EnchanterRecipe(NonNullList<IngredientWithCount> inputs, Holder<Enchantment> enchantment) {
        this.inputs = inputs;
        this.enchantment = enchantment;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        if (this.inputs.size() != inventory.ingredientCount() - 1) {
            return false;
        }
        NonNullList inputs = NonNullList.create();
        for (int i = 0; i < inventory.size() - 1; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.isEmpty()) continue;
            inputs.add((Object)item);
        }
        return RecipeMatcher.findMatches((List)inputs, this.inputs) != null;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider provider) {
        return this.getEnchantedOutputItemStack((RecipeInput)inventory);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs.stream().map(ICustomIngredient::toVanilla).collect(Collectors.toCollection(NonNullList::create));
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.ENCHANTER.get();
    }

    public RecipeType<? extends IEnchanterRecipe> getType() {
        return (RecipeType)ModRecipeTypes.ENCHANTER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        NonNullList remaining = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < 2; ++i) {
            ItemStack stack = inventory.getItem(i);
            int count = ((IngredientWithCount)this.inputs.get(i)).getCount() * this.getOutputEnchantmentLevel((RecipeInput)inventory);
            remaining.set(i, (Object)stack.copyWithCount(stack.getCount() - count));
        }
        ItemStack stack = inventory.getItem(2);
        if (stack.getCount() > 1) {
            remaining.set(2, (Object)stack.copyWithCount(stack.getCount() - 1));
        }
        return remaining;
    }

    @Override
    public Holder<Enchantment> getEnchantment() {
        return this.enchantment;
    }

    @Override
    public int getCount(int index) {
        if (index < 0 || index >= this.inputs.size()) {
            return -1;
        }
        return ((IngredientWithCount)this.inputs.get(index)).getCount();
    }

    private ItemStack getEnchantedOutputItemStack(RecipeInput inventory) {
        ItemStack stack = inventory.getItem(2);
        if (((Enchantment)this.enchantment.value()).canEnchant(stack)) {
            ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
            int newLevel = this.getOutputEnchantmentLevel(inventory);
            for (Holder enchantment : enchantments.keySet()) {
                if (enchantment == this.enchantment && enchantments.getLevel(enchantment) >= newLevel) {
                    return ItemStack.EMPTY;
                }
                if (enchantment == this.enchantment || !Enchantment.areCompatible((Holder)enchantment, this.enchantment)) continue;
                return ItemStack.EMPTY;
            }
            enchantments.set(this.enchantment, newLevel);
            ItemStack result = stack.copyWithCount(1);
            EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)enchantments.toImmutable());
            return result;
        }
        if (stack.is(Items.BOOK)) {
            return EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(this.enchantment, this.getOutputEnchantmentLevel(inventory)));
        }
        return ItemStack.EMPTY;
    }

    private int getOutputEnchantmentLevel(RecipeInput inventory) {
        int level = 0;
        for (int i = 0; i < this.inputs.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            int count = ((IngredientWithCount)this.inputs.get(i)).getCount();
            int newLevel = stack.getCount() / count;
            if (level != 0 && newLevel >= level) continue;
            level = Math.min(newLevel, ((Enchantment)this.enchantment.value()).getMaxLevel());
        }
        return level;
    }

    public static class Serializer
    implements RecipeSerializer<EnchanterRecipe> {
        public static final MapCodec<EnchanterRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IngredientWithCount.MAP_CODEC.codec().listOf().fieldOf("ingredients").flatXmap(field -> {
            int max = 2;
            Object[] ingredients = (IngredientWithCount[])field.toArray(IngredientWithCount[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for enchanter recipe");
            }
            return ingredients.length > max ? DataResult.error(() -> "Too many ingredients for enchanter recipe. The maximum is: %s".formatted(max)) : DataResult.success((Object)NonNullList.of((Object)IngredientWithCount.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(recipe -> recipe.inputs), (App)Enchantment.CODEC.fieldOf("enchantment").forGetter(recipe -> recipe.enchantment)).apply((Applicative)builder, EnchanterRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EnchanterRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<EnchanterRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EnchanterRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static EnchanterRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)IngredientWithCount.EMPTY);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)((IngredientWithCount)IngredientWithCount.STREAM_CODEC.decode((Object)buffer)));
            }
            Holder enchantment = (Holder)Enchantment.STREAM_CODEC.decode((Object)buffer);
            return new EnchanterRecipe((NonNullList<IngredientWithCount>)inputs, (Holder<Enchantment>)enchantment);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, EnchanterRecipe recipe) {
            buffer.writeVarInt(recipe.inputs.size());
            for (int i = 0; i < recipe.inputs.size(); ++i) {
                IngredientWithCount.STREAM_CODEC.encode((Object)buffer, (Object)((IngredientWithCount)recipe.inputs.get(i)));
            }
            Enchantment.STREAM_CODEC.encode((Object)buffer, recipe.enchantment);
        }
    }
}

