/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class AwakeningRecipe
implements IAwakeningRecipe {
    public static final int RECIPE_SIZE = 9;
    private final Ingredient input;
    private final NonNullList<Ingredient> inputs;
    private final NonNullList<ItemStack> essences;
    private final ItemStack result;
    private final boolean transferComponents;
    private BiFunction<Integer, ItemStack, ItemStack> transformer;

    public AwakeningRecipe(Ingredient input, NonNullList<Ingredient> inputs, NonNullList<ItemStack> essences, ItemStack result, boolean transferComponents) {
        this.input = input;
        this.essences = essences;
        this.result = result;
        this.transferComponents = transferComponents;
        NonNullList allInputs = NonNullList.withSize((int)8, (Object)Ingredient.EMPTY);
        allInputs.set(0, (Object)Ingredient.of((ItemStack[])new ItemStack[]{(ItemStack)essences.get(0)}));
        allInputs.set(1, (Object)((Ingredient)inputs.get(0)));
        allInputs.set(2, (Object)Ingredient.of((ItemStack[])new ItemStack[]{(ItemStack)essences.get(1)}));
        allInputs.set(3, (Object)((Ingredient)inputs.get(1)));
        allInputs.set(4, (Object)Ingredient.of((ItemStack[])new ItemStack[]{(ItemStack)essences.get(2)}));
        allInputs.set(5, (Object)((Ingredient)inputs.get(2)));
        allInputs.set(6, (Object)Ingredient.of((ItemStack[])new ItemStack[]{(ItemStack)essences.get(3)}));
        allInputs.set(7, (Object)((Ingredient)inputs.get(3)));
        this.inputs = allInputs;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        if (this.inputs.size() != inventory.ingredientCount() - 1) {
            return false;
        }
        ItemStack input = inventory.getItem(0);
        if (!this.input.test(input)) {
            return false;
        }
        NonNullList inputs = NonNullList.create();
        for (int i = 1; i < inventory.size(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.isEmpty()) continue;
            inputs.add((Object)item);
        }
        return RecipeMatcher.findMatches((List)inputs, this.inputs) != null;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider provider) {
        ItemStack stack = inventory.getItem(0);
        ItemStack result = this.result.copy();
        if (this.transferComponents) {
            result.applyComponents(stack.getComponentsPatch());
        }
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.AWAKENING.get();
    }

    public RecipeType<? extends IAwakeningRecipe> getType() {
        return (RecipeType)ModRecipeTypes.AWAKENING.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        NonNullList remaining = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        int vesselIndex = 0;
        block0: for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (i > 4) {
                Ingredient input = (Ingredient)this.inputs.get(vesselIndex);
                vesselIndex += 2;
                if (input.isEmpty()) continue;
                for (ItemStack essence : this.essences) {
                    if (input.getItems()[0] != essence) continue;
                    remaining.set(i, (Object)StackHelper.shrink((ItemStack)stack, (int)essence.getCount(), (boolean)false));
                    continue block0;
                }
                continue;
            }
            if (stack.hasCraftingRemainingItem()) {
                remaining.set(i, (Object)stack.getCraftingRemainingItem());
            }
            if (this.transformer == null) continue;
            boolean[] used = new boolean[remaining.size()];
            for (int j = 0; j < this.inputs.size(); j += 2) {
                Ingredient input = (Ingredient)this.inputs.get(j);
                if (used[j] || !input.test(stack)) continue;
                int index = Math.floorDiv(i, 2);
                ItemStack ingredient = this.transformer.apply(index, stack);
                used[j] = true;
                remaining.set(i, (Object)ingredient);
                continue block0;
            }
        }
        return remaining;
    }

    @Override
    public Ingredient getAltarIngredient() {
        return this.input;
    }

    @Override
    public NonNullList<ItemStack> getEssences() {
        return this.essences;
    }

    @Override
    public Map<ItemStack, Integer> getMissingEssences(List<ItemStack> items) {
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>((Collection<ItemStack>)this.essences);
        LinkedHashMap<ItemStack, Integer> missing = new LinkedHashMap<ItemStack, Integer>();
        block0: for (ItemStack item : items) {
            for (ItemStack essence : remaining) {
                int required;
                if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)essence)) continue;
                int current = item.getCount();
                if (current < (required = essence.getCount())) {
                    missing.put(essence, required - current);
                }
                remaining.remove(essence);
                continue block0;
            }
        }
        for (ItemStack essence : remaining) {
            missing.put(essence, essence.getCount());
        }
        return missing;
    }

    public void setTransformer(BiFunction<Integer, ItemStack, ItemStack> transformer) {
        this.transformer = transformer;
    }

    public static class Serializer
    implements RecipeSerializer<AwakeningRecipe> {
        public static final MapCodec<AwakeningRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(recipe -> recipe.input), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(field -> {
            int max = 4;
            Ingredient[] ingredients = (Ingredient[])field.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for awakening recipe");
            }
            if (ingredients.length > max) {
                return DataResult.error(() -> "Too many ingredients for awakening recipe. The maximum is: %s".formatted(max));
            }
            NonNullList result = NonNullList.withSize((int)max, (Object)Ingredient.EMPTY);
            for (int i = 0; i < ingredients.length; ++i) {
                result.set(i, (Object)ingredients[i]);
            }
            return DataResult.success((Object)result);
        }, DataResult::success).forGetter(recipe -> recipe.inputs), (App)ItemStack.STRICT_CODEC.listOf().fieldOf("essences").flatXmap(field -> {
            int max = 4;
            ItemStack[] stacks = (ItemStack[])field.toArray(ItemStack[]::new);
            if (stacks.length == 0) {
                return DataResult.error(() -> "No essences for awakening recipe");
            }
            if (stacks.length > max) {
                return DataResult.error(() -> "Too many essences for awakening recipe. The maximum is: %s".formatted(max));
            }
            NonNullList result = NonNullList.withSize((int)max, (Object)ItemStack.EMPTY);
            for (int i = 0; i < stacks.length; ++i) {
                result.set(i, (Object)stacks[i]);
            }
            return DataResult.success((Object)result);
        }, DataResult::success).forGetter(recipe -> recipe.essences), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("transfer_components", (Object)false).forGetter(recipe -> recipe.transferComponents)).apply((Applicative)builder, AwakeningRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AwakeningRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<AwakeningRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AwakeningRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static AwakeningRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            size = buffer.readVarInt();
            NonNullList essences = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            for (int i = 0; i < size; ++i) {
                essences.set(i, (Object)((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer)));
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean transferComponents = buffer.readBoolean();
            return new AwakeningRecipe(input, (NonNullList<Ingredient>)inputs, (NonNullList<ItemStack>)essences, result, transferComponents);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, AwakeningRecipe recipe) {
            int i;
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeVarInt(4);
            for (i = 1; i <= 7; i += 2) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((Ingredient)recipe.inputs.get(i)));
            }
            buffer.writeVarInt(4);
            for (i = 0; i < 4; ++i) {
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)((ItemStack)recipe.essences.get(i)));
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.transferComponents);
        }
    }
}

