/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.container.slot;

import com.blakebr0.cucumber.iface.IToggleableSlot;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugmentProvider;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AugmentSlot
extends SlotItemHandler
implements IToggleableSlot {
    private final AbstractContainerMenu container;
    private final int augmentSlot;

    public AugmentSlot(AbstractContainerMenu container, IItemHandler inventory, int index, int xPosition, int yPosition, int augmentSlot) {
        super(inventory, index, xPosition, yPosition);
        this.container = container;
        this.augmentSlot = augmentSlot;
    }

    public void onTake(Player player, ItemStack stack) {
        super.onTake(player, stack);
        this.container.slotsChanged(null);
    }

    public void set(ItemStack stack) {
        super.set(stack);
        this.container.slotsChanged(null);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public boolean mayPlace(ItemStack stack) {
        if (!super.mayPlace(stack) || !this.isActive()) {
            return false;
        }
        ItemStack stackInSlot = this.getItemHandler().getStackInSlot(0);
        Item tinkerableItem = stackInSlot.getItem();
        Item augmentItem = stack.getItem();
        if (tinkerableItem instanceof ITinkerable) {
            ITinkerable tinkerable = (ITinkerable)tinkerableItem;
            if (augmentItem instanceof IAugmentProvider) {
                IAugmentProvider augmentProvider = (IAugmentProvider)augmentItem;
                Augment augment = augmentProvider.getAugment();
                return tinkerable.canApplyAugment(augment);
            }
        }
        return false;
    }

    public boolean isActive() {
        ItemStack stack = this.getItemHandler().getStackInSlot(0);
        Item item = stack.getItem();
        if (item instanceof ITinkerable) {
            ITinkerable tinkerable = (ITinkerable)item;
            return this.augmentSlot < tinkerable.getAugmentSlots();
        }
        return false;
    }
}

