/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.cucumber.crafting.ingredient.IngredientWithCount;
import com.blakebr0.mysticalagriculture.api.crafting.ISouliumSpawnerRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.SouliumSpawnerRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.SouliumSpawnerCrafting")
@ZenRegister
public final class SouliumSpawnerCrafting
implements IRecipeManager<ISouliumSpawnerRecipe> {
    public RecipeType<ISouliumSpawnerRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredient input, int inputCount, String[] entities) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        IngredientWithCount ingredient = new IngredientWithCount((Ingredient.Value)new Ingredient.ItemValue(input.getItems()[0].getInternal()), inputCount);
        SouliumSpawnerRecipe recipe = new SouliumSpawnerRecipe(ingredient, SouliumSpawnerCrafting.toEntityTypeList(entities));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    @ZenCodeType.Method
    public void removeByEntity(String entity) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> ((ISouliumSpawnerRecipe)recipe.value()).getEntityTypes().unwrap().stream().anyMatch(e -> ((EntityType)e.data()).toString().equals(entity))));
    }

    private static WeightedRandomList<WeightedEntry.Wrapper<EntityType<?>>> toEntityTypeList(String[] entities) {
        ArrayList<WeightedEntry.Wrapper> entityTypes = new ArrayList<WeightedEntry.Wrapper>();
        for (String entity : entities) {
            String[] entityIDParts = entity.split("@");
            ResourceLocation entityTypeID = ResourceLocation.parse((String)entityIDParts[0]);
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityTypeID);
            int weight = 1;
            if (entityIDParts.length > 1) {
                weight = Integer.parseInt(entityIDParts[1]);
            }
            entityTypes.add(WeightedEntry.wrap((Object)entityType, (int)weight));
        }
        return WeightedRandomList.create(entityTypes);
    }
}

