/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.handler;

import com.blakebr0.mysticalagriculture.api.tinkering.AOEAugment;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.blakebr0.mysticalagriculture.network.payloads.UpdateAOEAugmentOffsetPayload;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public final class AOEAugmentClientHandler {
    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.player == null) {
            return;
        }
        ItemStack stack = minecraft.player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof ITinkerable)) {
            return;
        }
        long window = minecraft.getWindow().getWindow();
        if (!InputConstants.isKeyDown((long)window, (int)345) && !InputConstants.isKeyDown((long)window, (int)341)) {
            return;
        }
        int range = AugmentUtils.getMaxAOEAugmentRange(stack);
        if (range == 0) {
            return;
        }
        int horizontalOffsetChange = 0;
        int verticalOffsetChange = 0;
        if (InputConstants.isKeyDown((long)window, (int)263)) {
            horizontalOffsetChange = -1;
        } else if (InputConstants.isKeyDown((long)window, (int)262)) {
            horizontalOffsetChange = 1;
        } else if (InputConstants.isKeyDown((long)window, (int)264)) {
            verticalOffsetChange = -1;
        } else if (InputConstants.isKeyDown((long)window, (int)265)) {
            verticalOffsetChange = 1;
        }
        if (horizontalOffsetChange != 0 || verticalOffsetChange != 0) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateAOEAugmentOffsetPayload(horizontalOffsetChange, verticalOffsetChange), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onBlockHighlight(RenderHighlightEvent.Block event) {
        Camera camera = event.getCamera();
        Entity entity = camera.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof ITinkerable)) {
            return;
        }
        long window = Minecraft.getInstance().getWindow().getWindow();
        if (!InputConstants.isKeyDown((long)window, (int)345) && !InputConstants.isKeyDown((long)window, (int)341)) {
            return;
        }
        int range = AugmentUtils.getMaxAOEAugmentRange(stack);
        if (range == 0) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Vec3 cameraPos = camera.getPosition();
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        VertexConsumer buffer = event.getMultiBufferSource().getBuffer(RenderType.lines());
        float red = player.isCrouching() ? 1.0f : 0.0f;
        float green = player.isCrouching() ? 0.5f : 1.0f;
        float blue = 0.0f;
        float alpha = 0.7f;
        Direction direction = player.isCrouching() ? Direction.UP : event.getTarget().getDirection();
        AOEAugment.getAOEBlocks(stack, range, event.getTarget().getBlockPos(), direction, player).forEach(aoePos -> {
            BlockState state = player.level().getBlockState(aoePos);
            if (state.isAir()) {
                return;
            }
            AABB box = new AABB(aoePos).contract((double)(-direction.getStepX()), (double)(-direction.getStepY()), (double)(-direction.getStepZ()));
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)box, (float)red, (float)green, (float)blue, (float)alpha);
        });
        poseStack.popPose();
    }
}

