/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.HarvesterTileEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class HarvesterBlock
extends BaseTileEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty RUNNING = BooleanProperty.create((String)"running");

    public HarvesterBlock() {
        super(SoundType.METAL, 3.5f, 3.5f, true);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)RUNNING, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HarvesterTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof HarvesterTileEntity) {
            HarvesterTileEntity harvester = (HarvesterTileEntity)tile;
            player.openMenu((MenuProvider)harvester, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof HarvesterTileEntity) {
            HarvesterTileEntity harvester = (HarvesterTileEntity)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)harvester.getInventory().getStacks());
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)harvester.getUpgradeInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            String rangeString = String.valueOf(3);
            MutableComponent area = Component.literal((String)(rangeString + "x" + rangeString)).withStyle(ChatFormatting.WHITE);
            MutableComponent speed = Formatting.number((Object)100).withStyle(ChatFormatting.WHITE);
            MutableComponent fuelRate = Formatting.number((Object)10).withStyle(ChatFormatting.WHITE);
            MutableComponent fuelCapacity = Formatting.number((Object)80000).withStyle(ChatFormatting.WHITE);
            tooltip.add((Component)ModTooltips.MACHINE_AREA.args(new Object[]{area}).build());
            tooltip.add((Component)ModTooltips.MACHINE_SPEED.args(new Object[]{speed}).build());
            tooltip.add((Component)ModTooltips.MACHINE_FUEL_RATE.args(new Object[]{fuelRate}).build());
            tooltip.add((Component)ModTooltips.MACHINE_FUEL_CAPACITY.args(new Object[]{fuelCapacity}).build());
        } else {
            tooltip.add((Component)Tooltips.HOLD_SHIFT_FOR_INFO.build());
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return BlockHelper.getRedstoneSignalFromInventory((BlockEntity)level.getBlockEntity(pos));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, RUNNING});
    }

    protected <T extends BlockEntity> BlockEntityTicker<T> getServerTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return HarvesterBlock.createTicker(type, (BlockEntityType)((BlockEntityType)ModTileEntities.HARVESTER.get()), HarvesterTileEntity::tick);
    }
}

