/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureDataComponentTypes;
import com.blakebr0.mysticalagriculture.api.components.AugmentComponent;
import com.blakebr0.mysticalagriculture.api.tinkering.AOEAugment;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AugmentUtils {
    public static void addAugment(ItemStack stack, Augment augment, int slot) {
        ITinkerable tinkerable;
        Item item = stack.getItem();
        if (item instanceof ITinkerable && slot < (tinkerable = (ITinkerable)item).getAugmentSlots() && tinkerable.getTinkerableTier() >= augment.getTier()) {
            List component = (List)stack.get(MysticalAgricultureDataComponentTypes.EQUIPPED_AUGMENTS);
            ArrayList<AugmentComponent> augments = new ArrayList<AugmentComponent>();
            if (component != null && !component.isEmpty()) {
                augments.addAll(component);
            }
            augments.removeIf(a -> a.slot() == slot);
            augments.add(new AugmentComponent(augment.getId(), slot));
            stack.set(MysticalAgricultureDataComponentTypes.EQUIPPED_AUGMENTS, augments);
        }
    }

    public static void removeAugment(ItemStack stack, int slot) {
        List component = (List)stack.get(MysticalAgricultureDataComponentTypes.EQUIPPED_AUGMENTS);
        if (component == null) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof ITinkerable) {
            ITinkerable tinkerable = (ITinkerable)item;
            Augment augment = AugmentUtils.getAugment(stack, slot);
            if (slot < tinkerable.getAugmentSlots() && augment != null) {
                ArrayList<AugmentComponent> augments = new ArrayList<AugmentComponent>();
                if (!component.isEmpty()) {
                    augments.addAll(component);
                }
                augments.removeIf(a -> a.slot() == slot);
                stack.set(MysticalAgricultureDataComponentTypes.EQUIPPED_AUGMENTS, augments);
                stack.remove(MysticalAgricultureDataComponentTypes.AOE_AUGMENT_OFFSET);
            }
        }
    }

    public static Augment getAugment(ItemStack stack, int slot) {
        List component = (List)stack.get(MysticalAgricultureDataComponentTypes.EQUIPPED_AUGMENTS);
        if (component == null) {
            return null;
        }
        Item item = stack.getItem();
        if (item instanceof ITinkerable) {
            ITinkerable tinkerable = (ITinkerable)item;
            AugmentComponent augment = component.stream().filter(a -> a.slot() == slot).findFirst().orElse(null);
            if (augment == null) {
                return null;
            }
            if (slot < tinkerable.getAugmentSlots()) {
                return MysticalAgricultureAPI.getAugmentRegistry().getAugmentById(augment.id());
            }
        }
        return null;
    }

    public static List<Augment> getAugments(ItemStack stack) {
        List component = (List)stack.get(MysticalAgricultureDataComponentTypes.EQUIPPED_AUGMENTS);
        ArrayList<Augment> augments = new ArrayList<Augment>();
        if (component == null) {
            return augments;
        }
        Item item = stack.getItem();
        if (item instanceof ITinkerable) {
            ITinkerable tinkerable = (ITinkerable)item;
            int slots = tinkerable.getAugmentSlots();
            for (int i = 0; i < slots; ++i) {
                Augment augment = AugmentUtils.getAugment(stack, i);
                if (augment == null) continue;
                augments.add(augment);
            }
        }
        return augments;
    }

    public static List<Augment> getArmorAugments(Player player) {
        NonNullList armor = player.getInventory().armor;
        ArrayList<Augment> augments = new ArrayList<Augment>();
        for (ItemStack stack : armor) {
            augments.addAll(AugmentUtils.getAugments(stack));
        }
        return augments;
    }

    public static int getMaxAOEAugmentRange(ItemStack stack) {
        int range = 0;
        List<Augment> augments = AugmentUtils.getAugments(stack);
        for (Augment augment : augments) {
            if (!(augment instanceof AOEAugment)) continue;
            AOEAugment aoeAugment = (AOEAugment)augment;
            range = Math.max(range, aoeAugment.getRange());
        }
        return range;
    }
}

