/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.crop;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CropTier {
    public static final CropTier ELEMENTAL = new CropTier(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)"elemental"), 1, 7638528, ChatFormatting.YELLOW);
    public static final CropTier ONE = new CropTier(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)"1"), 1, 7638528, ChatFormatting.YELLOW);
    public static final CropTier TWO = new CropTier(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)"2"), 2, 35875, ChatFormatting.GREEN);
    public static final CropTier THREE = new CropTier(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)"3"), 3, 12011776, ChatFormatting.GOLD);
    public static final CropTier FOUR = new CropTier(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)"4"), 4, 32731, ChatFormatting.AQUA);
    public static final CropTier FIVE = new CropTier(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)"5"), 5, 0xC40000, ChatFormatting.RED);
    private final ResourceLocation id;
    private final int value;
    private final int color;
    private final ChatFormatting textColor;
    private Supplier<? extends Block> farmland;
    private Supplier<? extends Item> essence;
    private MutableComponent displayName;
    private boolean fertilizable;
    private boolean secondarySeedDrop;
    private double baseSecondaryChance;

    public CropTier(ResourceLocation id, int value, int color, ChatFormatting textColor) {
        this.id = id;
        this.value = value;
        this.color = color;
        this.textColor = textColor;
        this.fertilizable = true;
        this.secondarySeedDrop = true;
        this.baseSecondaryChance = 0.1;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.id.getPath();
    }

    public String getModId() {
        return this.id.getNamespace();
    }

    public int getValue() {
        return this.value;
    }

    public int getColor() {
        return this.color;
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }

    public Block getFarmland() {
        return this.farmland == null ? null : this.farmland.get();
    }

    public CropTier setFarmland(Supplier<? extends Block> farmland) {
        this.farmland = farmland;
        return this;
    }

    public Item getEssence() {
        return this.essence == null ? null : this.essence.get();
    }

    public CropTier setEssence(Supplier<? extends Item> essence) {
        this.essence = essence;
        return this;
    }

    public boolean isEffectiveFarmland(Block block) {
        return this.farmland != null && this.farmland.get() == block;
    }

    public MutableComponent getDisplayName() {
        if (this.displayName != null) {
            return this.displayName.withStyle(this.getTextColor());
        }
        return Component.translatable((String)String.format("cropTier.%s.%s", this.getModId(), this.getName())).withStyle(this.getTextColor());
    }

    public CropTier setDisplayName(MutableComponent name) {
        this.displayName = name;
        return this;
    }

    public boolean isFertilizable() {
        return this.fertilizable;
    }

    public CropTier setFertilizable(boolean fertilizable) {
        this.fertilizable = fertilizable;
        return this;
    }

    public boolean hasSecondarySeedDrop() {
        return this.secondarySeedDrop;
    }

    public CropTier setSecondarySeedDrop(boolean secondarySeedDrop) {
        this.secondarySeedDrop = secondarySeedDrop;
        return this;
    }

    public double getBaseSecondaryChance() {
        return this.baseSecondaryChance;
    }

    public CropTier setBaseSecondaryChance(double chance) {
        this.baseSecondaryChance = chance;
        return this;
    }
}

