/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.projectile;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.AdditionalSpawnDataEntity;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ThrowableBlock
extends ThrowableProjectile
implements AdditionalSpawnDataEntity {
    private static final EntityDataAccessor<OptionalInt> OWNER_ENTITY_ID = SynchedEntityData.defineId(ThrowableBlock.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final EntityDataAccessor<Boolean> HELD = SynchedEntityData.defineId(ThrowableBlock.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private BlockState blockState = Blocks.GRASS_BLOCK.defaultBlockState();
    @Nullable
    private EntityType<?> ownerType;

    public ThrowableBlock(EntityType<? extends ThrowableBlock> type, Level worldIn) {
        super(type, worldIn);
    }

    public ThrowableBlock(double x, double y, double z, LivingEntity entity) {
        super((EntityType)ModEntityTypes.THROWABLE_BLOCK_ENTITY_TYPE.value(), x, y, z, entity.level());
        this.setOwner((Entity)entity);
        this.ownerType = entity.getType();
    }

    public ThrowableBlock(MutantEnderman enderman, int id) {
        this(enderman.getX(), enderman.getY() + 4.7, enderman.getZ(), (LivingEntity)enderman);
        this.blockState = Block.stateById((int)enderman.getHeldBlock(id));
        boolean outer = id <= 1;
        boolean right = (id & 1) == 0;
        LivingEntity attackTarget = enderman.getTarget();
        Vec3 forward = EntityUtil.getDirVector(this.getYRot(), outer ? 2.7f : 1.4f);
        Vec3 strafe = EntityUtil.getDirVector(this.getYRot() + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.setPos(this.getX() + forward.x + strafe.x, this.getY() + (double)(outer ? 2.8f : 1.1f) - 4.8, this.getZ() + forward.z + strafe.z);
        if (attackTarget != null) {
            double d0 = attackTarget.getX() - this.getX();
            double d1 = attackTarget.getY(0.33) - this.getY();
            double d2 = attackTarget.getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            this.shoot(d0, d1 + d3 * 0.1, d2, 1.4f, 1.0f);
        } else {
            this.throwBlock((LivingEntity)enderman);
        }
    }

    public ThrowableBlock(MutantSnowGolem mutantSnowGolem) {
        this(mutantSnowGolem.getX(), mutantSnowGolem.getY() + 1.955 - 0.1 + 1.0, mutantSnowGolem.getZ(), (LivingEntity)mutantSnowGolem);
        this.setYRot(mutantSnowGolem.getYRot());
        this.blockState = Blocks.ICE.defaultBlockState();
    }

    public ThrowableBlock(Player player, BlockState blockState, BlockPos pos) {
        this((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, (LivingEntity)player);
        this.blockState = blockState;
        this.setHeld(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_ENTITY_ID, (Object)OptionalInt.empty());
        builder.define(HELD, (Object)false);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public EntityType<?> getOwnerType() {
        return this.ownerType;
    }

    public boolean isHeld() {
        return (Boolean)this.entityData.get(HELD);
    }

    private void setHeld(boolean held) {
        this.entityData.set(HELD, (Object)held);
    }

    public void setOwner(Entity entityIn) {
        super.setOwner(entityIn);
        if (entityIn != null) {
            this.entityData.set(OWNER_ENTITY_ID, (Object)OptionalInt.of(entityIn.getId()));
        }
    }

    protected double getDefaultGravity() {
        if (this.ownerType == EntityType.PLAYER) {
            return 0.04;
        }
        if (this.ownerType == ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.value()) {
            return 0.06;
        }
        return 0.01;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean isPickable() {
        return this.isAlive() && this.ownerType != ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.value();
    }

    public boolean isPushable() {
        return this.isHeld() && this.isAlive();
    }

    public void push(Entity entityIn) {
        if (entityIn != this.getOwner()) {
            super.push(entityIn);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth();
                double y = this.getY() + 0.5 + (double)(this.random.nextFloat() * this.getBbHeight());
                double z = this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth();
                double motx = (this.random.nextFloat() - this.random.nextFloat()) * 3.0f;
                double moty = 0.5f + this.random.nextFloat() * 2.0f;
                double motz = (this.random.nextFloat() - this.random.nextFloat()) * 3.0f;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.blockState), x, y, z, motx, moty, motz);
            }
        }
    }

    public void tick() {
        if (this.isHeld()) {
            if (!this.level().isClientSide) {
                this.setSharedFlag(6, this.hasGlowingTag());
            }
            this.baseTick();
            Entity thrower = this.getOwner();
            if (thrower == null) {
                Entity entity;
                OptionalInt optionalInt = (OptionalInt)this.entityData.get(OWNER_ENTITY_ID);
                if (optionalInt.isPresent() && (entity = this.level().getEntity(optionalInt.getAsInt())) instanceof LivingEntity) {
                    thrower = entity;
                }
                if (thrower != null) {
                    this.setOwner(thrower);
                }
            } else if (thrower instanceof LivingEntity) {
                Vec3 vec = thrower.getLookAngle();
                double x = thrower.getX() + vec.x * 1.6 - this.getX();
                double y = thrower.getEyeY() + vec.y * 1.6 - this.getY();
                double z = thrower.getZ() + vec.z * 1.6 - this.getZ();
                float offset = 0.6f;
                this.setDeltaMovement(x * (double)offset, y * (double)offset, z * (double)offset);
                this.move(MoverType.SELF, this.getDeltaMovement());
                if (!(this.level().isClientSide || thrower.isAlive() && !thrower.isSpectator() && ((LivingEntity)thrower).isHolding((Item)ModItems.ENDERSOUL_HAND_ITEM.value()))) {
                    this.setHeld(false);
                }
            }
        } else {
            super.tick();
            this.hasImpulse = true;
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (!super.canHitEntity(entity)) {
            return false;
        }
        return this.ownerType != ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.value() || MutantSnowGolem.canHarm(this.getOwner(), entity);
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (itemStack.getItem() != ModItems.ENDERSOUL_HAND_ITEM.value()) {
            return InteractionResult.PASS;
        }
        if (this.isHeld()) {
            if (this.getOwner() == player) {
                if (!this.level().isClientSide) {
                    this.setHeld(false);
                    this.throwBlock((LivingEntity)player);
                }
                ItemHelper.hurtAndBreak((ItemStack)itemStack, (int)1, (LivingEntity)player, (InteractionHand)interactionHand);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            this.setHeld(true);
            this.setOwner((Entity)player);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    private void throwBlock(LivingEntity thrower) {
        this.setYRot(thrower.getYRot());
        this.setXRot(thrower.getXRot());
        float f = 0.4f;
        this.shoot(-Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(this.getXRot() / 180.0f * (float)Math.PI)) * f, -Mth.sin((float)(this.getXRot() / 180.0f * (float)Math.PI)) * f, Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(this.getXRot() / 180.0f * (float)Math.PI)) * f, 1.4f, 1.0f);
    }

    protected void onHit(HitResult result) {
        LivingEntity livingEntity;
        Entity thrower = this.getOwner();
        LivingEntity livingEntity2 = livingEntity = thrower instanceof LivingEntity ? (LivingEntity)thrower : null;
        if (this.ownerType == ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.value()) {
            Entity entity;
            for (Mob mobEntity : this.level().getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(2.5, 2.0, 2.5), this::canHitEntity)) {
                if (!(this.distanceToSqr((Entity)mobEntity) <= 6.25)) continue;
                mobEntity.hurt(this.level().damageSources().mobProjectile((Entity)this, livingEntity), 4.0f + (float)this.random.nextInt(3));
            }
            if (result.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)result).getEntity()).hurt(this.level().damageSources().thrown((Entity)this, (Entity)livingEntity), 4.0f) && entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (!this.level().isClientSide) {
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
                this.discard();
            }
            this.playSound(this.blockState.getSoundType().getBreakSound(), 0.8f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.8f);
        } else {
            boolean canOwnerPlace;
            boolean bl = canOwnerPlace = livingEntity instanceof Player && ((Player)livingEntity).mayBuild() || livingEntity instanceof Mob && CommonAbstractions.INSTANCE.getMobGriefingRule(this.level(), (Entity)livingEntity);
            if (result.getType() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = (BlockHitResult)result;
                this.onHitBlock(blockHitResult);
                if (!this.level().isClientSide) {
                    BlockPos blockPos = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
                    if (canOwnerPlace && this.level().getBlockState(blockPos).canBeReplaced() && this.blockState.canSurvive((LevelReader)this.level(), blockPos)) {
                        this.level().setBlockAndUpdate(blockPos, this.blockState);
                        this.blockState.getBlock().setPlacedBy(this.level(), blockPos, this.blockState, livingEntity, ItemStack.EMPTY);
                        SoundType soundType = this.blockState.getSoundType();
                        this.playSound(soundType.getPlaceSound(), (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                    } else {
                        this.level().levelEvent(2001, blockPos, Block.getId((BlockState)this.blockState));
                        if (canOwnerPlace && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            this.spawnAtLocation((ItemLike)this.blockState.getBlock());
                        }
                    }
                }
            } else if (result.getType() == HitResult.Type.ENTITY && !this.level().isClientSide) {
                Entity entity = ((EntityHitResult)result).getEntity();
                if (entity.hurt(this.level().damageSources().thrown((Entity)this, (Entity)livingEntity), 4.0f) && entity.getType() == EntityType.ENDERMAN) {
                    return;
                }
                this.level().levelEvent(2001, this.blockPosition(), Block.getId((BlockState)this.blockState));
                if (canOwnerPlace && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.spawnAtLocation((ItemLike)this.blockState.getBlock());
                }
            }
            for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox().inflate(2.0), this::canHitEntity)) {
                if (entity.is((Entity)livingEntity) || !(this.distanceToSqr(entity) <= 4.0)) continue;
                entity.hurt(this.level().damageSources().mobProjectile((Entity)this, livingEntity), (float)(6 + this.random.nextInt(3)));
            }
            if (!this.level().isClientSide) {
                this.discard();
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.blockState));
        compound.putBoolean("Held", this.isHeld());
        if (this.ownerType != null) {
            compound.putString("OwnerType", BuiltInRegistries.ENTITY_TYPE.getKey(this.ownerType).toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHeld(compound.getBoolean("Held"));
        if (compound.contains("BlockState", 10)) {
            this.blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("BlockState"));
        }
        if (compound.contains("OwnerType")) {
            this.ownerType = EntityType.byString((String)compound.getString("OwnerType")).orElse(null);
        }
    }

    @Override
    public void writeAdditionalAddEntityData(FriendlyByteBuf buffer) {
        buffer.writeVarInt(Block.getId((BlockState)this.blockState));
        buffer.writeUtf(this.ownerType == null ? "" : BuiltInRegistries.ENTITY_TYPE.getKey(this.ownerType).toString());
    }

    @Override
    public void readAdditionalAddEntityData(FriendlyByteBuf additionalData) {
        this.blockState = Block.stateById((int)additionalData.readVarInt());
        this.ownerType = EntityType.byString((String)additionalData.readUtf(Short.MAX_VALUE)).orElse(null);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return AdditionalSpawnDataEntity.getPacket(this, serverEntity);
    }
}

