/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.ai.goal;

import fuzs.mutantmonsters.world.entity.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.EntityAnimation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AnimationGoal<T extends Mob>
extends Goal {
    protected final T mob;

    public AnimationGoal(T mob) {
        this.mob = mob;
    }

    public boolean isInterruptable() {
        return false;
    }

    protected abstract EntityAnimation getAnimation();

    public boolean canUse() {
        return ((AnimatedEntity)this.mob).getAnimation() == this.getAnimation();
    }

    public void start() {
        AnimatedEntity.sendAnimationPacket(this.mob, this.getAnimation());
    }

    public boolean canContinueToUse() {
        return ((AnimatedEntity)this.mob).getAnimation() == this.getAnimation() && ((AnimatedEntity)this.mob).getAnimationTick() < this.getAnimation().duration();
    }

    public void stop() {
        AnimatedEntity.sendAnimationPacket(this.mob, EntityAnimation.NONE);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

