/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.proxy.Proxy;
import fuzs.mutantmonsters.services.CommonAbstractions;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CreeperMinionEgg
extends Entity {
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.defineId(CreeperMinionEgg.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int health = 8;
    private int age = (60 + this.random.nextInt(40)) * 1200;
    private int recentlyHit;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private UUID owner;
    private int dismountTicks;

    public CreeperMinionEgg(EntityType<? extends CreeperMinionEgg> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public CreeperMinionEgg(MutantCreeper spawner, Entity owner) {
        this((EntityType<? extends CreeperMinionEgg>)((EntityType)ModEntityTypes.CREEPER_MINION_EGG_ENTITY_TYPE.value()), spawner.level());
        this.owner = owner.getUUID();
        this.setPos(spawner.getX(), spawner.getY(), spawner.getZ());
        if (spawner.isCharged()) {
            this.setCharged(true);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CHARGED, (Object)false);
    }

    public boolean isCharged() {
        return (Boolean)this.entityData.get(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.entityData.set(CHARGED, (Object)charged);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean canCollideWith(Entity entity) {
        return Boat.canVehicleCollide((Entity)this, (Entity)entity);
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public boolean isPushable() {
        return this.isAlive();
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int steps) {
        super.lerpTo(x, y, z, yaw, pitch, steps);
        this.setDeltaMovement(this.velocityX, this.velocityY, this.velocityZ);
    }

    public void lerpMotion(double x, double y, double z) {
        super.lerpMotion(x, y, z);
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
    }

    private void hatch() {
        Player playerEntity;
        CreeperMinion minion = (CreeperMinion)((EntityType)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.value()).create(this.level());
        if (this.owner != null && (playerEntity = this.level().getPlayerByUUID(this.owner)) != null && !CommonAbstractions.INSTANCE.onAnimalTame((Animal)minion, playerEntity)) {
            minion.tame(playerEntity);
            minion.setOrderedToSit(true);
        }
        if (this.isCharged()) {
            minion.setCharged(true);
        }
        minion.setPos(this.getX(), this.getY(), this.getZ());
        this.level().addFreshEntity((Entity)minion);
        this.playSound((SoundEvent)ModSoundEvents.ENTITY_CREEPER_MINION_EGG_HATCH_SOUND_EVENT.value(), 0.7f, 0.9f + this.random.nextFloat() * 0.1f);
        this.discard();
    }

    public void thunderHit(ServerLevel serverWorld, LightningBolt lightningBoltEntity) {
        super.thunderHit(serverWorld, lightningBoltEntity);
        this.setCharged(true);
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, 0.0, 0.7));
        }
        if (this.isPassenger()) {
            if (this.getFirstPassenger() != null) {
                this.dismountTicks = 10;
            } else if (this.dismountTicks > 0) {
                --this.dismountTicks;
            }
            Entity rootVehicle = this.getRootVehicle();
            if (this.isInWall() || !rootVehicle.hasPose(Pose.STANDING) && !rootVehicle.hasPose(Pose.CROUCHING) || this.dismountTicks <= 0 && rootVehicle.isShiftKeyDown() || rootVehicle.isSpectator()) {
                this.stopRiding();
                this.playMountSound(false);
            }
        }
        if (!this.level().isClientSide) {
            Player player;
            if (this.health < 8 && this.tickCount - this.recentlyHit > 80 && this.tickCount % 20 == 0) {
                ++this.health;
            }
            if (--this.age <= 0 && this.owner != null && (player = this.level().getPlayerByUUID(this.owner)) != null && this.distanceToSqr((Entity)player) < 4096.0) {
                this.hatch();
            }
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!player.isSecondaryUseActive() && player.hasPose(Pose.STANDING) && !player.hasPassenger((Entity)this)) {
            Entity topPassenger = this.getTopPassenger((Entity)player);
            this.startRiding(topPassenger, true);
            this.playMountSound(true);
            if (this.level().isClientSide) {
                Proxy.INSTANCE.showDismountMessage();
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    private Entity getTopPassenger(Entity entity) {
        List list = entity.getPassengers();
        return !list.isEmpty() ? this.getTopPassenger((Entity)list.get(0)) : entity;
    }

    private void playMountSound(boolean mount) {
        this.playSound(SoundEvents.ITEM_PICKUP, 0.7f, (mount ? 0.6f : 0.3f) + this.random.nextFloat() * 0.1f);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide && this.isAlive()) {
            this.markHurt();
            if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                this.age = (int)((float)this.age - amount * 80.0f);
                EntityUtil.sendParticlePacket(this, (ParticleOptions)ParticleTypes.HEART, (int)(amount / 2.0f));
                return false;
            }
            this.recentlyHit = this.tickCount;
            this.setDeltaMovement(0.0, 0.2, 0.0);
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                float sizeIn = this.isCharged() ? 2.0f : 0.0f;
                MutatedExplosionHelper.explode(this, sizeIn, false, Level.ExplosionInteraction.TNT);
                if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    if (!this.isCharged() && this.random.nextInt(3) != 0) {
                        for (int i = 5 + this.random.nextInt(6); i > 0; --i) {
                            this.spawnAtLocation((ItemLike)Items.GUNPOWDER);
                        }
                    } else {
                        this.spawnAtLocation((ItemLike)ModItems.CREEPER_SHARD_ITEM.value());
                    }
                }
                this.discard();
            }
            return true;
        }
        return false;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Health", this.health);
        compound.putInt("Age", this.age);
        compound.putInt("RecentlyHit", this.recentlyHit);
        if (this.isCharged()) {
            compound.putBoolean("Charged", true);
        }
        if (this.owner != null) {
            compound.putUUID("Owner", this.owner);
        }
        compound.putByte("DismountTicks", (byte)this.dismountTicks);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Health")) {
            this.health = compound.getInt("Health");
        }
        if (compound.contains("Age")) {
            this.age = compound.getInt("Age");
        }
        this.recentlyHit = compound.getInt("RecentlyHit");
        this.setCharged(compound.getBoolean("Charged"));
        if (compound.hasUUID("Owner")) {
            this.owner = compound.getUUID("Owner");
        }
        this.dismountTicks = compound.getByte("DismountTicks");
    }
}

