/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.mutantmonsters.world.level.SeismicWave;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEventsHandler {
    public static EventResult onItemUseTick(LivingEntity entity, ItemStack useItem, MutableInt useItemRemaining) {
        if (entity.getItemBySlot(EquipmentSlot.CHEST).is(ModItems.MUTANT_SKELETON_CHESTPLATE_ITEM) && useItem.getItem() instanceof BowItem && BowItem.getPowerForTime((int)(useItem.getUseDuration(entity) - useItemRemaining.getAsInt())) < 1.0f) {
            useItemRemaining.mapInt(i -> i - 2);
        }
        return EventResult.PASS;
    }

    public static EventResult onArrowLoose(Player player, ItemStack weapon, Level level, MutableInt charge, boolean hasAmmo) {
        if (player.getItemBySlot(EquipmentSlot.HEAD).is(ModItems.MUTANT_SKELETON_SKULL_ITEM) && weapon.getItem() instanceof BowItem) {
            Holder enchantment = LookupHelper.lookupEnchantment((LevelReader)level, (ResourceKey)Enchantments.MULTISHOT);
            if (weapon.getEnchantments().getLevel(enchantment) == 0) {
                ItemStack itemStack = weapon.copy();
                itemStack.enchant(enchantment, 1);
                itemStack.releaseUsing(level, (LivingEntity)player, player.getUseItemRemainingTicks());
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void onEndPlayerTick(Player player) {
        SeismicWave seismicWave;
        PlayerEventsHandler.playShoulderEntitySound(player, player.getShoulderEntityLeft());
        PlayerEventsHandler.playShoulderEntitySound(player, player.getShoulderEntityRight());
        if (!player.level().isClientSide && (seismicWave = SeismicWave.poll(player)) != null) {
            PlayerEventsHandler.handleSeismicWave(player, seismicWave);
        }
    }

    private static void handleSeismicWave(Player player, @NotNull SeismicWave seismicWave) {
        seismicWave.affectBlocks(player.level(), (Entity)player);
        AABB box = new AABB((double)seismicWave.getX(), (double)seismicWave.getY() + 1.0, (double)seismicWave.getZ(), (double)seismicWave.getX() + 1.0, (double)seismicWave.getY() + 2.0, (double)seismicWave.getZ() + 1.0);
        for (LivingEntity livingEntity : player.level().getEntitiesOfClass(LivingEntity.class, box)) {
            if (livingEntity == player || player.getVehicle() == livingEntity) continue;
            livingEntity.hurt(DamageSourcesHelper.source((LevelReader)player.level(), ModRegistry.PLAYER_SEISMIC_WAVE_DAMAGE_TYPE, (Entity)player), (float)(6 + player.getRandom().nextInt(3)));
        }
    }

    private static void playShoulderEntitySound(Player player, @Nullable CompoundTag compoundNBT) {
        block3: {
            block2: {
                if (compoundNBT != null && !compoundNBT.contains("Silent")) break block2;
                if (compoundNBT.getBoolean("Silent")) break block3;
            }
            EntityType.byString((String)compoundNBT.getString("id")).filter(((EntityType)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.value())::equals).ifPresent(entityType -> {
                if (player.level().random.nextInt(500) == 0) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSoundEvents.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.value(), player.getSoundSource(), 1.0f, (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.2f + 1.5f);
                }
            });
        }
    }

    public static EventResult onItemToss(Player player, ItemEntity itemEntity) {
        if (!player.level().isClientSide) {
            boolean isHand;
            ItemStack itemStack = itemEntity.getItem();
            boolean bl = isHand = itemStack.getItem() == ModItems.ENDERSOUL_HAND_ITEM.value() && itemStack.isDamaged();
            if (itemStack.getItem() == Items.ENDER_EYE || isHand) {
                int endersoulFragments = 0;
                for (EndersoulFragment endersoulFragment : player.level().getEntitiesOfClass(EndersoulFragment.class, player.getBoundingBox().inflate(8.0))) {
                    if (endersoulFragment.getOwner() != player) continue;
                    ++endersoulFragments;
                    endersoulFragment.discard();
                }
                if (endersoulFragments > 0) {
                    EntityUtil.sendParticlePacket((Entity)player, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.value(), 256);
                    int additionalDamageValue = endersoulFragments * 60;
                    if (isHand) {
                        int damageValue = itemStack.getDamageValue() - additionalDamageValue;
                        itemStack.setDamageValue(Math.max(damageValue, 0));
                    } else {
                        ItemStack newItemStack = new ItemStack((ItemLike)ModItems.ENDERSOUL_HAND_ITEM.value());
                        newItemStack.setDamageValue(newItemStack.getMaxDamage() - additionalDamageValue);
                        itemEntity.setItem(newItemStack);
                    }
                }
            }
        }
        return EventResult.PASS;
    }
}

