/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.CreeperMinionEggModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.client.renderer.entity.layers.CreeperChargeLayer;
import fuzs.mutantmonsters.world.entity.CreeperMinionEgg;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;

public class CreeperMinionEggRenderer
extends EntityRenderer<CreeperMinionEgg> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/creeper_minion_egg.png");
    private final CreeperMinionEggModel eggModel;
    private final CreeperMinionEggModel chargedModel;

    public CreeperMinionEggRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.eggModel = new CreeperMinionEggModel(context.bakeLayer(ClientModRegistry.CREEPER_MINION_EGG));
        this.chargedModel = new CreeperMinionEggModel(context.bakeLayer(ClientModRegistry.CREEPER_MINION_EGG_ARMOR));
        this.shadowRadius = 0.4f;
    }

    public void render(CreeperMinionEgg creeperMinionEgg, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render((Entity)creeperMinionEgg, entityYaw, partialTick, poseStack, multiBufferSource, packedLight);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.translate(0.0, -1.5, 0.0);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(this.eggModel.renderType(this.getTextureLocation(creeperMinionEgg)));
        this.eggModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        if (creeperMinionEgg.isCharged()) {
            float ageInTicks = (float)creeperMinionEgg.tickCount + partialTick;
            vertexConsumer = multiBufferSource.getBuffer(MutantRenderTypes.energySwirl(CreeperChargeLayer.LIGHTNING_TEXTURE, ageInTicks * 0.01f, ageInTicks * 0.01f));
            int color = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
            this.chargedModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(CreeperMinionEgg creeperMinionEgg) {
        return TEXTURE_LOCATION;
    }
}

