/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantSkeletonPartModel;
import fuzs.mutantmonsters.client.renderer.entity.MutantSkeletonRenderer;
import fuzs.mutantmonsters.world.entity.MutantSkeletonBodyPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class BodyPartRenderer
extends EntityRenderer<MutantSkeletonBodyPart> {
    private final MutantSkeletonPartModel partModel;

    public BodyPartRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.partModel = new MutantSkeletonPartModel(context.bakeLayer(ClientModRegistry.MUTANT_SKELETON_PART), context.bakeLayer(ClientModRegistry.MUTANT_SKELETON_PART_SPINE));
    }

    public void render(MutantSkeletonBodyPart entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot())));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        matrixStackIn.scale(1.2f, -1.2f, -1.2f);
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(this.partModel.renderType(this.getTextureLocation(entityIn)));
        this.partModel.getPart(entityIn.getPart()).render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(MutantSkeletonBodyPart entity) {
        return MutantSkeletonRenderer.TEXTURE_LOCATION;
    }
}

