/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class ModelHelper {
    @Nullable
    public static final Direction[] DIRECTIONS_WITH_NULL = Arrays.copyOf(Direction.values(), 7);
    public static final ItemTransform TRANSFORM_BLOCK_GUI;
    public static final ItemTransform TRANSFORM_BLOCK_GROUND;
    public static final ItemTransform TRANSFORM_BLOCK_FIXED;
    public static final ItemTransform TRANSFORM_BLOCK_3RD_PERSON_RIGHT;
    public static final ItemTransform TRANSFORM_BLOCK_1ST_PERSON_RIGHT;
    public static final ItemTransform TRANSFORM_BLOCK_1ST_PERSON_LEFT;
    public static final ItemTransforms MODEL_TRANSFORM_BLOCK;

    public static int nullableDirectionIndex(@Nullable Direction side) {
        return side == null ? 6 : side.get3DDataValue();
    }

    public static BakedQuad bakeSprite(QuadBakingVertexConsumer vc, Direction d, TextureAtlasSprite sprite, float depth) {
        vc.setTintIndex(-1);
        vc.setDirection(d);
        vc.setSprite(sprite);
        vc.setShade(true);
        vc.setHasAmbientOcclusion(true);
        Vector3f[] pos = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f()};
        ModelHelper.square(pos, d, 0.0f, 0.0f, 1.0f, 1.0f, depth);
        Vector2f[] uv = ModelHelper.bakeUvs(pos, sprite, d);
        for (int i = 0; i < 4; ++i) {
            vc.addVertex(pos[i].x, pos[i].y, pos[i].z);
            vc.setColor(255, 255, 255, 255);
            vc.setUv(uv[i].x, uv[i].y);
            vc.setLight(0);
            Vec3i normal = d.getNormal();
            vc.setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
        }
        return vc.bakeQuad();
    }

    public static void square(Vector3f[] out, Direction nominalFace, float left, float bottom, float right, float top, float depth) {
        switch (nominalFace) {
            case UP: {
                depth = 1.0f - depth;
                top = 1.0f - top;
                bottom = 1.0f - bottom;
            }
            case DOWN: {
                out[0].set(left, depth, top);
                out[1].set(left, depth, bottom);
                out[2].set(right, depth, bottom);
                out[3].set(right, depth, top);
                break;
            }
            case EAST: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case WEST: {
                out[0].set(depth, top, left);
                out[1].set(depth, bottom, left);
                out[2].set(depth, bottom, right);
                out[3].set(depth, top, right);
                break;
            }
            case SOUTH: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case NORTH: {
                out[0].set(1.0f - left, top, depth);
                out[1].set(1.0f - left, bottom, depth);
                out[2].set(1.0f - right, bottom, depth);
                out[3].set(1.0f - right, top, depth);
            }
        }
    }

    public static Vector2f[] bakeUvs(Vector3f[] pos, TextureAtlasSprite sprite, Direction face) {
        Vector2f[] uvs = new Vector2f[4];
        for (int i = 0; i < 4; ++i) {
            uvs[i] = ModelHelper.lockUvs(pos[i], face);
        }
        ModelHelper.interpolate(uvs, sprite);
        return uvs;
    }

    private static Vector2f lockUvs(Vector3f pos, Direction face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.EAST -> new Vector2f(1.0f - pos.z(), 1.0f - pos.y());
            case Direction.WEST -> new Vector2f(pos.z(), 1.0f - pos.y());
            case Direction.NORTH -> new Vector2f(1.0f - pos.x(), 1.0f - pos.y());
            case Direction.SOUTH -> new Vector2f(pos.x(), 1.0f - pos.y());
            case Direction.DOWN -> new Vector2f(pos.x(), 1.0f - pos.z());
            case Direction.UP -> new Vector2f(pos.x(), pos.z());
        };
    }

    private static void interpolate(Vector2f[] uvs, TextureAtlasSprite sprite) {
        float uMin = sprite.getU0();
        float uSpan = sprite.getU1() - uMin;
        float vMin = sprite.getV0();
        float vSpan = sprite.getV1() - vMin;
        for (int i = 0; i < 4; ++i) {
            uvs[i].set(uMin + uvs[i].x * uSpan, vMin + uvs[i].y * vSpan);
        }
    }

    private static ItemTransform makeTransform(float rotationX, float rotationY, float rotationZ, float translationX, float translationY, float translationZ, float scaleX, float scaleY, float scaleZ) {
        Vector3f translation = new Vector3f(translationX, translationY, translationZ);
        translation.mul(0.0625f);
        translation.set(Mth.clamp((float)translation.x, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.y, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.z, (float)-5.0f, (float)5.0f));
        return new ItemTransform(new Vector3f(rotationX, rotationY, rotationZ), translation, new Vector3f(scaleX, scaleY, scaleZ));
    }

    static {
        ModelHelper.DIRECTIONS_WITH_NULL[6] = null;
        TRANSFORM_BLOCK_GUI = ModelHelper.makeTransform(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
        TRANSFORM_BLOCK_GROUND = ModelHelper.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
        TRANSFORM_BLOCK_FIXED = ModelHelper.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
        TRANSFORM_BLOCK_3RD_PERSON_RIGHT = ModelHelper.makeTransform(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
        TRANSFORM_BLOCK_1ST_PERSON_RIGHT = ModelHelper.makeTransform(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        TRANSFORM_BLOCK_1ST_PERSON_LEFT = ModelHelper.makeTransform(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        MODEL_TRANSFORM_BLOCK = new ItemTransforms(TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_1ST_PERSON_LEFT, TRANSFORM_BLOCK_1ST_PERSON_RIGHT, ItemTransform.NO_TRANSFORM, TRANSFORM_BLOCK_GUI, TRANSFORM_BLOCK_GROUND, TRANSFORM_BLOCK_FIXED, ImmutableMap.of());
    }
}

