/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StorageView;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import aztech.modern_industrialization.thirdparty.fabrictransfer.impl.TransferApiImpl;
import com.google.common.collect.Iterators;
import java.util.Iterator;

public interface Storage<T>
extends Iterable<StorageView<T>> {
    public static <T> Storage<T> empty() {
        return TransferApiImpl.EMPTY_STORAGE;
    }

    default public boolean supportsInsertion() {
        return true;
    }

    public long insert(T var1, long var2, TransactionContext var4);

    default public boolean supportsExtraction() {
        return true;
    }

    public long extract(T var1, long var2, TransactionContext var4);

    @Override
    public Iterator<StorageView<T>> iterator();

    default public Iterator<StorageView<T>> nonEmptyIterator() {
        return Iterators.filter(this.iterator(), view -> view.getAmount() > 0L && !view.isResourceBlank());
    }

    default public Iterable<StorageView<T>> nonEmptyViews() {
        return this::nonEmptyIterator;
    }

    default public long getVersion() {
        if (Transaction.isOpen()) {
            throw new IllegalStateException("getVersion() may not be called during a transaction.");
        }
        return TransferApiImpl.version.getAndIncrement();
    }

    public static <T> Class<Storage<T>> asClass() {
        return Storage.class;
    }
}

